<?php

namespace App\General;
use DateTime;
class GeoLoacation
{
    public static function isPointWithinRadius($point, $center, $radius) {
        $earthRadius = 6371; // Earth's radius in kilometers
        
        $lat1 = deg2rad($point['latitude']);
        $lon1 = deg2rad($point['longitude']);
        $lat2 = deg2rad($center['latitude']);
        $lon2 = deg2rad($center['longitude']);
        
        $dlat = $lat2 - $lat1;
        $dlon = $lon2 - $lon1;
        
        $a = sin($dlat / 2) * sin($dlat / 2) + cos($lat1) * cos($lat2) * sin($dlon / 2) * sin($dlon / 2);
        $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
        
        $distance = $earthRadius * $c;
        
        return $distance <= $radius;
    }
}