<?php


namespace App\Jobs;

use App\Traits\EmailTrait;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use App\Models\SchedulerEmailSend;
use Illuminate\Support\Facades\Mail;
use App\Http\Controllers\Controller;

class SendEmailJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, EmailTrait;

    protected $schedulerData;

    public function __construct($schedulerData)
    {
        $this->schedulerData = $schedulerData;
    }

    
    public function handle()
    {

        $controller = new Controller();
        $this->SendEmail($this->schedulerData);
    }
}



?>