<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmpTeam extends Model
{
    use HasFactory;

    protected $fillable = ['title', 'supervisor','description'];

    public function teamSupervisor()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'supervisor');
    }

    public function teamsMember()
    {
        return $this->hasMany(EmpTeamsMember::class, 'id', 'team_id');
    }

    public function emp_teams_member()
    {
        return $this->hasMany(EmpTeamsMember::class, 'team_id', 'id')
            ->with(['roster_assigns' => function($query) {
                $query->where('schedule_date', date('Y-m-d'))
                    ->with('team_employee_attendance');
            }])->select('id','team_id','emp_id');
    }
}
