<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeavePackage extends Model
{
    use HasFactory;
    protected $fillable = [
        'title',
        'leave_type_id',
        'leave_number',
        'is_paid',
        'color_code',
        'renew_on',
        'employee_roles'
        ];


    public function leaveType()
    {
        return $this->belongsTo(LeaveType::class, 'leave_type_id');
    }
}
