<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveRequest extends Model
{
    use HasFactory;
    protected $fillable = [
        'employee_id',
        'leave_package_id',
        'from',
        'to',
        'reason',
        'applied_by',
        'status',
        'approved_by',
        'full_day',
        'end_time',
        'start_time',
        'number_of_leaves',
        'paid_days',
        'paid_dates',
        'custom_approval_reason'
    ];

        public function leavepackage()
        {
            return $this->belongsTo(LeavePackage::class, 'leave_package_id');
        }
       
        public function emppersonaldetails()
        {
            return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id');
        }

        public function empDetails()
        {
            return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'employee_id');
        }

        public function empCompanyDetails() {
            return $this->belongsTo(EmpCompanyDetails::class, 'employee_id');
        }
        public function leave_employee_details()
        {
            return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
        }
}
