<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequiredDocument extends Model
{
    use HasFactory;

    protected $fillable = ['title','identity_text','identity_file'];

    public function requiredDocumentField()
    {
      return $this->hasMany(RequiredDocumentField::class, 'doc_id', 'id')->orderBy('priority');
    }

    public function dashboardRequiredDocumentField()
    {
      return $this->hasOne(RequiredDocumentField::class, 'doc_id', 'id')->orderBy('priority')
              ->where(['field_required' => 1,'field_name'=>'Expiry Date'])->select('id','doc_id','field_name');
    }
} 
