<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RosterTemplate extends Model
{
    use HasFactory;
    protected $fillable = [
        'start_time',
        'end_time',
        'color_code',
        'break_minutes',
        'shift_notes',
        'repeat_shift',
        'end_date',
        'is_saved',
        'created_by',
        'created_at',
        'updated_at',
        'repeat_every',
        'working_hours',
        'status',
    ];

    public function RosterTemplate()
    {
        return $this->belongsTo(RosterTemplate::class, 'roster_template_id');
    }
    public function rosterAssign()
    {
        return $this->hasOne(RosterAssign::class, 'id', 'roster_template_id');
    }
    public function assigns()
    {
        return $this->hasMany(RosterAssign::class, 'roster_template_id'); // Adjust the foreign key name if necessary
    }
}
