<?php

namespace App\Traits;
use App\Models\RosterTemplate;
use App\Models\EmpPersonalDetails;
use App\Models\EmpCompanyDetails;
use App\Models\RosterAssign;
use App\Models\RosterHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use DB;
use Carbon\Carbon;
use App\Jobs\SendEmailJob;
use App\Models\PublicHoliday;

trait RosterTemplateTrait
{
    public function exampleFunction()
    {
        return response()->json([
            'message' => 'Shift Create Successfully this is eampale of simple trait'
        ],200);
    }

    public function handleRosterTemplate($request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'date' => 'required',
            'template_id' => 'required',
            'publish' => 'required',
            'start_time' => 'required',
            'end_time' => 'required',
            'break_minutes' => 'required',
            'color_code' => 'required',
            'shift_notes' => 'required',
            'repeat_shift' => 'required',
            'repeat_every' => 'required',
            'end_date' => 'required',
            'save_shift' => 'required',
            'edit' => 'nullable',
            'working_hours' => 'nullable'
        ]);
        if ($validator->fails()) {
            $errors = $validator->errors()->first();
            return response()->json([
                'message' => $errors
            ], 422);
        } 
        else 
        {
            $validatedData = $validator->validated();
            $start_ = Carbon::parse($request->start_time);
            $end_ = Carbon::parse($request->end_time);
            $required_minutes = $end_->diffInMinutes($start_);
            $required_minutes -= $request->break_minutes ?? 0;

            if ($request->date < date('Y-m-d'))
             {
                return response()->json([
                    'message' => 'Scheduler does not allow changes to be made for past dates.'
                ], 422);
            }

            if ($request->end_date < $request->date) 
            {
                return response()->json([
                    'message' => 'End Date must be bigger than or equal to ' . date('d-m-Y', strtotime($request->date)) . ' date.'
                ], 422);
            }
            $fixedStartTime = $request->start_time; 
            $fixedEndTime = $request->end_time; 
            $overlapExists = RosterAssign::where('assign_to',$request->user_id)->where('schedule_date',$request->date)->pluck('roster_template_id');
            if($request->edit == "edit")
            {
                $templateId = $request->template_id;
                $overlapExists = $overlapExists->reject(function($value) use ($templateId) {
                    return $value == $templateId;
                });
            }
            if($request->edit == "edit")
            {
               $existingTemplate = RosterTemplate::where(['id' => $request->template_id ])->first();
               if (!$existingTemplate) {
                return response()->json(['message' => 'Template not found'], 404);
                }
                // Compare only the specified fields
                $fieldsToCompare = ['start_time', 'end_time', 'break_minutes', 'color_code','working_hours'];            
                $changes = [];
                foreach ($fieldsToCompare as $field) {
                    if ($existingTemplate->$field != $validatedData[$field]) {
                        $changes[$field] = [
                            'old' => $existingTemplate->$field,
                            'new' => $validatedData[$field]
                        ];
                    }
                }
                // If there are changes, return them
                if (empty($changes)) {
                    RosterTemplate::where('id', $request->template_id)->update(['shift_notes' => $request->shift_notes]);
                    return response()->json([
                        'message' => 'No Data  changed',
                       
                    ]);
                }                     
            }
            if($overlapExists)
            {  
                $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
                foreach ($matchingTemplates as $range) {
                    $start = $range->start_time; 
                    $end =  $range->end_time; 
                    if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
                        return response()->json([
                            'message' => 'Shift Conflict :already assigned a shift during this time. Please choose a different time slot.  '
                        ],422);  
                    }
                }
                
            }
            if($request->edit == "edit")
            {
                RosterAssign::where([
                    'assign_to' => $request->user_id,
                    'roster_template_id' =>  $request->template_id,
                    'schedule_date' => $request->date,
                ])->delete();
            }
            if($request->save_shift == '1')
            {
                // Check for existing template with all fields matching
                $exists = RosterTemplate::where([
                    'start_time'    => $request->start_time,
                    'end_time'      => $request->end_time,
                    'break_minutes' => $request->break_minutes,
                    'working_hours' => $request->working_hours * 60, // assuming working_hours is in hours in request
                    'created_by'    => Auth::user()->id,
                    'status'      => 1,
                    'is_saved'      => 1
                ])->exists();
                if ($exists) {
                    return response()->json([
                        'message' => 'A template with the same details already exists. No new template was saved.'
                    ], 422);
                }

                $insert_id = RosterTemplate::insertGetId([
                    'start_time' => $request->start_time,
                    'end_time' => $request->end_time,
                    'break_minutes' => $request->break_minutes,
                    'color_code' => $request->color_code,
                    'shift_notes' => $request->shift_notes,
                    'repeat_shift' => '0',
                    'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
                    'end_date' => $request->end_date,
                    'is_saved' => $request->save_shift,
                    'working_hours' => $request->working_hours * 60,
                    'created_by' =>  Auth::user()->id
                ]);
            }
            else
            {
                $insert_id =   RosterTemplate::insertGetId([
                    'start_time' => $request->start_time,
                    'end_time' => $request->end_time,
                    'break_minutes' => $request->break_minutes,
                    'color_code' => $request->color_code,
                    'shift_notes' => $request->shift_notes,
                    'repeat_shift' => $request->repeat_shift,
                    'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
                    'end_date' => $request->end_date,
                    'working_hours' => $request->working_hours * 60,
                    'is_saved' => '0',
                    'created_by' =>  Auth::user()->id
                ]);
            }
            
            $getDatesBetweens = $this->getDatesBetween($request->date, $request->end_date);
            $header_date =  Carbon::parse($request->date);
            if($request->repeat_shift == '1'){
                foreach ($getDatesBetweens as $key => $getDatesBetween) 
                {
                    $getDatesBetween =  Carbon::parse($getDatesBetween);
                    if($request->repeat_every == '2' )
                    {
                        if($header_date->format('D') == $getDatesBetween->format('D') && $key % 2 == 0 )
                        {
                            RosterAssign::insertGetId([
                                'assign_to' => $request->user_id,
                                'roster_template_id' =>  $insert_id,
                                'schedule_date' => $getDatesBetween,
                            ]);
                                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
                                $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
                                $history_arr = [
                                    'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
                                    'roster_template_id' => $insert_id
                                ];

                                $this->storeHistory($history_arr);
                        }

                    }
                    else
                    {
                        if($header_date->format('D') == $getDatesBetween->format('D'))
                        {
                            RosterAssign::insertGetId([
                                'assign_to' => $request->user_id,
                                'roster_template_id' =>  $insert_id,
                                'schedule_date' => $getDatesBetween,
                            ]);
                            $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
                            $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
                            $history_arr = [
                                'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
                                'roster_template_id' => $insert_id
                            ];
                            $this->storeHistory($history_arr);
                        }

                    }

                }
            }
            else
            {
                RosterAssign::insertGetId([
                    'assign_to' => $request->user_id,
                    'roster_template_id' =>  $insert_id,
                    'schedule_date' => $request->date,
                ]);
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
                $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
                $history_arr = [
                    'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
                    'roster_template_id' => $insert_id
                ];
                $this->storeHistory($history_arr);
            }
            if($request->publish)
            {
                $this->publish_specific_person($request->user_id);
            }
            return response()->json([
                'message' => 'Shift Create Successfully'
            ],200);
            
        }



    }

    public function rosterTemplateAssign($request)
    {
        if($request->date < date('Y-m-d'))
        {
            return response()->json([
                'message' => 'Scheduler does not allow changes to be made for past dates.'
            ],422); 
        }
        $RosterTemplate =   RosterTemplate::find($request->template_id);
        $start_ = Carbon::parse($RosterTemplate->start_time);
        $end_ = Carbon::parse($RosterTemplate->end_time);
        $required_minutes =  $end_->diffInMinutes($start_); 
        $required_minutes = $required_minutes - $RosterTemplate->break_minutes ?? 0;
        $fixedStartTime = $RosterTemplate->start_time;
        $fixedEndTime = $RosterTemplate->end_time;
        $overlapExists = RosterAssign::where('assign_to',$request->user_id)->where('schedule_date',$request->date)->pluck('roster_template_id');
        if($overlapExists)
        {
            $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
            foreach ($matchingTemplates as $range) {
                $start = $range->start_time; 
                $end =  $range->end_time; 
                if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
                    return response()->json([
                        'message' => ' Shift Conflict :already assigned a shift during this time. Please choose a different time slot. '
                    ],422);
                   
                }
                else{
                    // return response()->json([
                    //     'message' => 'Done  Please choose a different time slot. '
                    // ],422);
                }
            }
            
        }
        RosterAssign::insert([
            'assign_to' => $request->user_id,
            'roster_template_id' => $request->template_id,
            'schedule_date' => $request->date,
        ]);
        $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
        $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
        $history_arr = [
            'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$request->template_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
            'roster_template_id' => $request->template_id
        ];
        $this->storeHistory($history_arr);
        return response()->json([
            'message' => 'Template Assign Successfully'
        ],200);


    }
    public function bulkScheduleRoasterCreate($validatedData,$request)
    {
       
        // $validator = Validator::make($request->all(), [
        //     'start_date' => 'required',
        //     'end_date' => 'required|after_or_equal:start_date',
        //     'start_time' => 'required',
        //     'end_time' => 'required|after:start_time',
        //     'color_code' => 'required',
        //     'break_minutes' => 'required',
        //     'shift_notes' => 'required',
        //     'users_ids' => ['required', 'array', 'min:1'],
        //     'working_days_hidden' => 'required'
        // ],[

        //     'end_time.after' => 'End time must be after start time',
        //     'users_ids.required' => 'Please select atleast one employee',
        //     'working_days_hidden.required' => 'Please select atleast one day'
        // ]);
        // if ($validator->fails()) {
        //     $errors = $validator->errors()->first();
        //     return response()->json([
        //         'message' => $errors
        //     ],422);
        // }
    
            // dd($request);
            // $validatedData =  $validator->validated();
            // dd($validatedData);
            
            $days_array =  explode(",", $validatedData['working_days_hidden']);
            $start_ = Carbon::parse($request['start_time']);
            $end_ = Carbon::parse($request['end_time']);
            $required_minutes =  $end_->diffInMinutes($start_); 
            $required_minutes = $required_minutes - $request['break_minutes'] ?? 0;
            // $days_array = $this->getShortDayNames($days_array);
            if($request['start_date'] < date('Y-m-d'))
            {
                return response()->json([
                    'message' => 'Scheduler does not allow changes to be made for past dates.'
                ],422); 
            }
                
            $getDatesBetweens = $this->getDatesBetween($request['start_date'], $request['end_date']);

            foreach($getDatesBetweens as $for_this_date)
            {
               if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
               {
                   continue;
               }
               foreach($request['users_ids'] as  $user_id)
               {         
                   $fixedStartTime = $request['start_time']; 
                   $fixedEndTime = $request['end_time']; 
                   $overlapExists = RosterAssign::where('assign_to', $user_id)
                           ->where('schedule_date', $for_this_date)
                           ->pluck('roster_template_id');
                   if ($overlapExists->isNotEmpty()) {
                       // Fetch the matching templates
                       $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
                       // Iterate through the matching templates to check for overlaps
                       foreach ($matchingTemplates as $range) {
                           $start = $range->start_time; 
                           $end = $range->end_time; 
                           // Check if there is an overlap
                           if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
                               $emp= EmpCompanyDetails::find($user_id);
                               return response()->json([
                                   'message' => 'Shift Conflict'.' '
                                   . $emp->empPersonalDetails->first_name . ' '
                                   . ($emp->empPersonalDetails->middle_name ? $emp->empPersonalDetails->middle_name . ' ' : '') // Check if middle name exists
                                   . $emp->empPersonalDetails->last_name.' '
                                   .':is already assigned a shift during this time. Please choose a different time slot.'
                               ], 422);
                              
                           }
                           else{
                               // return response()->json([
                               //     'message' => 'Done  Please choose a different time slot. '
                               // ],422);
                           }
                           
                       }
                   }  
                   

               }

            } 
            $insert_id = 0;
            $shiftAlreadyCreated = false;
            foreach($getDatesBetweens as $for_this_date)
            {
                if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
                {
                    continue;
                }
                foreach($request['users_ids'] as  $user_id)
                {         
                    if (!$shiftAlreadyCreated) {
                        $insert_id =   RosterTemplate::insertGetId([
                            'start_time' => $request['start_time'],
                            'end_time' => $request['end_time'],
                            'break_minutes' => $request['break_minutes'],
                            'color_code' => $request['color_code'],
                            'shift_notes' => $request['shift_notes'],
                            'repeat_shift' => 0,
                            'repeat_every' => 0,
                            'end_date' => $for_this_date,
                            'working_hours' => $request['working_hours'] * 60,
                            'is_saved' => '0',
                           'created_by' => Auth::check() ? Auth::user()->id : 1
                        ]);
                        $shiftAlreadyCreated = true;
                    }
                    RosterAssign::insertGetId([
                        'assign_to' => $user_id,
                        'roster_template_id' =>  $insert_id,
                        'schedule_date' => $for_this_date,
                    ]);

                }
            }
            if(Auth::check() )
            {
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
                $history_arr = [
                    'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> created a bulk schedule at ".date('d-m-Y')." date",
                    'roster_template_id' => 0
                ];
                $this->storeHistory($history_arr);
            }
            else
            {
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', 1)->first();
                $history_arr = [
                    'description' => "<a href='".url('/')."/user-profile/1"."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> created a bulk schedule at ".date('d-m-Y')." date",
                    'roster_template_id' => 0
                ];
                $this->storeHistory($history_arr);

            }
            
            return response()->json([
                'message' => 'Bulk Schedule Created Successfully'
            ],200);
        
    }

    function getDatesBetween($start_date, $end_date)
    {
        $dates = [];

        $start = Carbon::parse($start_date);
        $end = Carbon::parse($end_date);

        while ($start->lte($end)) {
            $dates[] = $start->toDateString();
            $start->addDay();
        }

        return $dates;
    }

    public function storeHistory($arr)
    {
        RosterHistory::create([
            'roster_template_id' => $arr['roster_template_id'],
            'updated_by' => Auth::check() ? Auth::user()->id : 1,
            'description' => $arr['description']
        ]);

    }
    private function isOverlap($start1, $end1, $start2, $end2)
    {
        // Normalize the intervals by checking if they cross midnight
        if ($start1 > $end1) {
            $end1 = date('H:i:s', strtotime($end1) + 86400); // Add 24 hours to end1
        }
        if ($start2 > $end2) {
            $end2 = date('H:i:s', strtotime($end2) + 86400); // Add 24 hours to end2
        }
        return $start1 < $end2 && $start2 < $end1;
    }

    function getShortDayNames($days) {
        $shortDays = array();
    
        foreach ($days as $day) {
            switch($day) {
                case "Monday":
                    $shortDays[] = "Mon";
                    break;
                case "Tuesday":
                    $shortDays[] = "Tue";
                    break;
                case "Wednesday":
                    $shortDays[] = "Wed";
                    break;
                case "Thursday":
                    $shortDays[] = "Thu";
                    break;
                case "Friday":
                    $shortDays[] = "Fri";
                    break;
                case "Saturday":
                    $shortDays[] = "Sat";
                    break;
                case "Sunday":
                    $shortDays[] = "Sun";
                    break;
                default:
                    $shortDays[] = "Invalid day";
                    break;
            }
        }
    
        return $shortDays;
    }





}