<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roster_templates', function (Blueprint $table) {
            $table->id();
            $table->time('start_time', $precision = 0);
            $table->time('end_time', $precision = 0);
            $table->string('color_code',10);
            $table->integer('break_minutes');
            $table->text('shift_notes');
            $table->string('repeat_shift');
            $table->date('end_date');
            $table->integer('is_saved')->default(0);
            $table->integer('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roster_templates');
    }
}
