<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id');
            $table->integer('pay_year');
            $table->integer('pay_month');
            $table->integer('basic_salary');
            $table->integer('working_hours');
            $table->integer('hours_spent');
            $table->decimal('actual_working_hours', 5, 2);
            $table->decimal('overtime_hours', 5, 2);
            $table->integer('calculated_salary');
            $table->integer('status');
            $table->timestamps();

            // Foreign key constraint (ensure your employees table exists)
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
