<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOvertimesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('overtimes', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id');
            $table->integer('site_id');
            $table->datetime('check_in'); // Stores both date and time
            $table->datetime('check_out'); // Stores both date and time
            $table->date('date'); // Specific column for just the date
            $table->string('working_hours')->nullable();
            $table->longText('description')->nullable();
            $table->string('status')->nullable(); // Status of the overtime
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('overtimes');
    }
}
