@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body p-0">
                <div class="">

                    <div class="attendance-detail justify-content-end align-items-center">
                        <div class="ms-2 me-auto">
                            <div class="h4 pb-0 mb-0 attendance-detail_heading">Manual Attendance Request</div>
                        </div>
                        @if (in_array('Attendance Request Maintain', Session::get('permissions')))
                            <div class="p-2 attendance-detail_btn">
                                <button class="btn btn-warning px-3" onclick="approveSelected();">Approved Selected</button>
                            </div>
                        @endif

                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th>
                                        <div class="pb-2">
                                            <input class="form-check-input w-px-20 h-px-20 master_check" type="checkbox"
                                                value="" id="checkAll">
                                        </div>
                                    </th>
                                    <th style="width: 15%;">
                                        <input type="text" class="filter-form filter form-control" name="first_name"
                                            id="" placeholder="Employee" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name"
                                            autocomplete="false">
                                    </th>
                                    <th>
                                        <input type="text" class="filter-added-form  filter form-control"
                                            name="first_name_add" id="" placeholder="Added By" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name_add"
                                            autocomplete="false">
                                    </th>
                                    <th style="width: 12%;">
                                        <select class="filter select-color" style="border-radius:0;" name="user_type"
                                            id="">
                                            <option value="">Type</option>
                                            <option value="0">Internal</option>
                                            <option value="1">External</option>
                                        </select>
                                    </th>
                                    <th>
                                        <input type="text" class="filter form-control" name="title" id=""
                                            placeholder="Site" autocomplete="off">
                                        <input type="text" style="display:none" name="title" autocomplete="false">
                                    </th>
                                    <th>
                                        <input type="time" class="filter form-control"
                                            style="font-size: 10px;padding: 4px !important;" name="Check_in" id=""
                                            placeholder="Check In" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-Check_in"
                                            autocomplete="false">
                                    </th>
                                    <th>
                                        <input type="time" class="filter form-control"
                                            style="font-size: 10px;padding: 4px !important;" name="Check_out" id=""
                                            placeholder="Check Out" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-Check_out"
                                            autocomplete="false">
                                    </th>
                                    <th>
                                        <input type="text" class="filter form-control" name="date" id=""
                                            placeholder="Date" autocomplete="off">
                                        <input type="text" style="display:none" name="date-working_hours"
                                            autocomplete="false">
                                    </th>
                                    <th style="width: 11%;">
                                        <select class="filter select-color " name="status" id="">
                                            <option value="">Status</option>
                                            <option value="1">Approved</option>
                                            <option value="2">Rejected</option>
                                            <option value="0">Pending</option>
                                        </select>
                                    </th>
                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-end pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
@section('css-js')
    <script>
        function approved_all() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "post",
                url: "/approved-all",
                success: function(response) {
                    toastr.success(response.message);
                    _get(0);
                    $('#checkAll input[type="checkbox"]').prop('checked', false);
                },
                error: function(response) {
                    if (response.status == 500) {
                        toaster.error("Something went wrong")
                    } else {
                        toaster.error(response.responseeJSON.message)
                    }
                }
            });
        }




        $(document).ready(function() {

            $('input[name="date"]').daterangepicker({
                locale: {
                    format: 'DD-MM-YYYY',
                    separator: ' / '
                }
            });

            _filter(0);
            _get(0);

        });

        function formatDate(dateString) {
            const parts = dateString.split('-');
            const formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
            return formattedDate;
        }

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {

            $.ajax({
                type: "GET",
                url: `{{ url('/attendance_request') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    console.log(response);
                    var attendances = response.data.attendances;
                    console.log(attendances);
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                        }

                    }

                    pages_btn += `

                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < attendances.length; i++) {

                        html += `
                        <tr>
                            <td>
                                <div class="form-check pt-1">
                                    <input class="form-check-input sub_check" type="checkbox" value="" data-id="${attendances[i].id}" id="checkbox_checked_${attendances[i].id}">
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${attendances[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                    <div class="ms-1">
                                        ${attendances[i].emp_personal_details ?

                                        `${attendances[i].emp_personal_details.first_name || ''}
                                                                 ${attendances[i].emp_personal_details.middle_name || ''}
                                                                 ${attendances[i].emp_personal_details.last_name || ''}
                                                                `
                                        : ''}
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex ${attendances[i].addedby ? ''  : 'invisible' }  align-items-center ">
                                    <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${attendances[i].addedby ?  attendances[i].addedby.image : ''}'); background-size: cover; background-repeat:no-repeat"></div>
                                    <div class="ms-1">
                                        ${attendances[i].addedby ?

                                        `${attendances[i].addedby.first_name || ''}
                                                                 ${attendances[i].addedby.middle_name || ''}
                                                                 ${attendances[i].addedby.last_name || ''}
                                                                `
                                        : ''}
                                    </div>

                                </div>
                            </td>
                            <td class="user_type-col${attendances[i]?.id}">
                            ${attendances[i]?.emp_company_details.user_type == "0" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Internal</span>'
                            :
                            '<span class="badge rounded-pill bg-label-warning me-1">External</span>'
                             }

                            </td>
                            <td>${attendances[i]?.sites?.title ?? 'Global Site'}</td>
                            <td class="text-primary">${attendances[i].check_in ? _24_to_12_time(attendances[i].check_in) : ''}</td>
                            <td class="text-primary ">${attendances[i].check_out ? _24_to_12_time(attendances[i].check_out) : ''}</td>
                            <td>${formatDate(attendances[i].date)}</td>
                            <td>
                                <span class="badge rounded-pill ${
                                    attendances[i]?.status == 0 ? 'bg-label-warning' :
                                    attendances[i]?.status == 1 ? 'bg-label-success' :
                                    attendances[i]?.status == 2 ? 'bg-label-danger' :
                                    ''
                                } me-1">
                                    ${attendances[i]?.status == 0 ? 'Pending' :
                                    attendances[i]?.status == 1 ? 'Approved' :
                                    attendances[i]?.status == 2 ? 'Rejected' :
                                    ''
                                    }
                                </span>
                            </td>

                            <td>
                            @if (in_array('Attendance Request Maintain', Session::get('permissions')))
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              <li><a class="dropdown-item py-1 ps-2"  onclick="window.location='/attendance/${attendances[i]?.id}/edit'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              </ul>
                              </div>
                              @endif
                            </td>
                        </tr>`;
                    }
                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }
        $(document).ready(function() {
            $(document).on('change', '.master_check', function() {
                if ($(this).is(":checked")) {
                    $(".sub_check").prop("checked", true);
                } else {
                    $(".sub_check").prop("checked", false);
                }
            });

            $(document).on('change', '.sub_check', function() {
                if ($(".sub_check:checked").length === $(".sub_check").length) {
                    $(".master_check").prop("checked", true);
                } else {
                    $(".master_check").prop("checked", false);
                }
            });
        });


        function approveSelected() {
            var selectedIds = [];

            $("input[type='checkbox']:checked").each(function() {
                var id = $(this).data('id');
                console.log(id);
                selectedIds.push(id);
            });

            if (selectedIds.length > 0) {
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    type: "post",
                    url: "/approve-selected",
                    data: {
                        ids: selectedIds
                    },
                    success: function(response) {
                        toastr.success(response.message);
                        _get(0);
                    },
                    error: function(response) {
                        if (response.status == 500) {
                            toaster.error("Something went wrong")
                        } else {
                            toaster.error(response.responseJSON.message)
                        }
                    }
                });
            } else {
                console.log("No checkboxes selected");
            }
        }
    </script>
    <style>
        .bg-primary th {
            color: white;
        }

        .filter {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .filter-form {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .filter-added-form {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .select-color {
            color: #787878;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 2px;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }

        .bg-primary th {
            color: white;
        }


        .attendance-detail {
            display: flex;
        }

        @media only screen and (min-width: 320px)and (max-width: 520px) {
            .attendance-detail {
                display: block;
                text-align: center;
                margin: 20px 0 20px 0;
            }

            .attendance-detail_heading {
                font-size: 18px
            }

            .attendance-detail_btn {
                margin-top: 12px
            }

            .btn-group {
                margin-bottom: 10px;
            }

            .select-field {
                margin-left: 15px;
            }
        }
    </style>
@endsection
