@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Button with Badges -->
        <div class="card mb-4 ">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0 ">Add Manual Attendance</div>
            </div>
            <form id="manual-attendacne-form">
                <div class="row p-3">
                    <div class="col-6 mb-3">
                        <label>Employee</label>
                        <select class="form-select" name="employee" aria-label="Default select example">
                            <option value="" selected disabled>Select Employee</option>
                            @foreach ($get_employes as $get_employe)
                                @if ($get_employe->EmpPersonalDetails)
                                    <option value="{{ $get_employe->id }}">
                                        {{ $get_employe->EmpPersonalDetails->first_name }}
                                        {{ $get_employe->EmpPersonalDetails->middle_name }}
                                        {{ $get_employe->EmpPersonalDetails->last_name }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Sites</label>
                        <select class="form-select" name="site" aria-label="Default select example">
                            <option value="" selected disabled>Select Site</option>
                            @foreach ($sites as $site)
                                <option value="{{ $site->id }}">{{ $site->title }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check In</label>
                        <input type="Time" name="check_in" class="form-control" id="" value="">
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check Out</label>
                        <input type="Time" name="check_out" class="form-control" id="" value="">
                    </div>
                    <div class="col-12 col-md-6 mb-3">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date" id="exampleColorInput" value="">
                    </div>
                    <div id="statusDiv" class="col-6 mb-3">
                        <label>Status</label>
                        <select class="form-select" aria-label="Default select example" name="status">
                            <option selected>--select--</option>
                            <option value="0">Pending</option>
                            <option value="1">Approved</option>
                            <option value="2">Rejected</option>
                        </select>
                    </div>


                </div>
                <div class="bg-primary h-px-30 px-0"></div>
                <div class="d-flex justify-content-around p-2 align-items-center">
                    <div class="break_width">
                        <label>Break In</label>
                        <input type="Time" name="break_in[]" class="form-control" id="exampleColorInput">
                    </div>
                    <div class="break_width">
                        <label>Break Out</label>
                        <input type="Time" name="break_out[]" class="form-control" id="exampleColorInput">
                    </div>
                    {{-- <div class="btn_width d-flex justify-content-end">
                    <a type="button" class=" px-2">
                         <span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span></a>
                </div> --}}
                </div>
                <div class="add_colum"> </div>
                <div class="d-flex justify-content-end">
                    <button class="border-none bg-transparent" type="button" onclick="addmore();"
                        style="padding-right:12px;">
                        <svg xmlns="http://www.w3.org/2000/svg" width="43" height="43" viewBox="0 0 43 43"
                            fill="none">
                            <g filter="url(#filter0_d_2182_1189)">
                                <rect x="4" y="2" width="35" height="35" rx="4" fill="#019FF3" />
                            </g>
                            <path
                                d="M30.221 9H13.4026C12.0757 9 11 10.0757 11 11.4026V28.221C11 29.5479 12.0757 30.6236 13.4026 30.6236H30.221C31.5479 30.6236 32.6236 29.5479 32.6236 28.221V11.4026C32.6236 10.0757 31.5479 9 30.221 9Z"
                                stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M21.8125 15.0078V24.6183" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <path d="M17.0068 19.8105H26.6173" stroke="white" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" />
                            <defs>
                                <filter id="filter0_d_2182_1189" x="0" y="0" width="43" height="43"
                                    filterUnits="userSpaceOnUse" color-interpolation-filters="sRGB">
                                    <feFlood flood-opacity="0" result="BackgroundImageFix" />
                                    <feColorMatrix in="SourceAlpha" type="matrix"
                                        values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" result="hardAlpha" />
                                    <feOffset dy="2" />
                                    <feGaussianBlur stdDeviation="2" />
                                    <feComposite in2="hardAlpha" operator="out" />
                                    <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0" />
                                    <feBlend mode="normal" in2="BackgroundImageFix"
                                        result="effect1_dropShadow_2182_1189" />
                                    <feBlend mode="normal" in="SourceGraphic" in2="effect1_dropShadow_2182_1189"
                                        result="shape" />
                                </filter>
                            </defs>
                        </svg>
                    </button>
                </div>
                <div class="border-top p-3 d-flex justify-content-end">
                    <button type="button" class="btn btn-outline-light text-dark me-2"
                        onclick="window.location='{{ url('/') }}/attendance'">CANCEL</button>
                    <button type="button" class="btn btn-primary waves-effect"
                        onclick=manual_attendance_store();>SAVE</button>
                </div>
            </form>
        </div>


    </div>
@endsection
@section('css-js')
    <script>
        function addmore() {
            var newColumn = `<div class="d-flex added-row justify-content-around p-3 align-items-center">
                <div class="break_width">
                    <label>Break In</label>
                    <input type="time" name="break_in[]" class="form-control" value="">
                </div>
                <div class="break_width">
                    <label>Break Out</label>
                    <input type="time" name="break_out[]" class="form-control" value="">
                </div>
                <div class="btn_width d-flex cursor-pointer">
                    <span class="mdi mdi-trash-can-outline mdi-20px text-danger" onclick="removeRow(this)"></span>
                </div>
            </div> `;

            $(".add_colum").append(newColumn);
        }

        function removeRow(button) {
            $(button).closest('.added-row').remove();
        }

        function manual_attendance_store() {
            var formData = $('#manual-attendacne-form').serialize();

            $.ajax({
                url: "{{ url('/attendance') }}",
                type: 'POST',
                data: formData,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    window.location.href = "{{ url('/') }}/attendance";
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }
    </script>
@endsection
