<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="../assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>Dashboard - Analytics | Materio - Bootstrap Material Design Admin Template</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <link rel="icon" type="image/x-icon" href="../assets/img/favicon/favicon.ico" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="../assets/vendor/fonts/materialdesignicons.css" />
    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="../assets/vendor/libs/node-waves/node-waves.css" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" />
    <link rel="stylesheet" href="../assets/css/demo.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="../assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="../assets/vendor/js/helpers.js"></script>
    <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
    <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
    <script src="../assets/js/config.js"></script>
</head>
<style>
    .authentication-wrapper .authentication-image-model {
        width: 768px;
    }

    .authentication-wrapper.authentication-cover .authentication-inner {
        min-height: 100vh;
        position: relative;
    }

    .authentication-wrapper .authentication-inner {
        width: 100%;
    }

    .authentication-wrapper.authentication-cover .authentication-image-tree {
        position: absolute;
        bottom: 3rem;
        left: 3rem;
    }

    .authentication-wrapper.authentication-cover .authentication-image {
        inset-inline-start: unset;
    }

    .authentication-wrapper .authentication-image {
        z-index: -1;
        inline-size: 100%;
        position: absolute;
        inset-inline-start: 0;
        bottom: 0;
    }

    .light-style .authentication-wrapper .authentication-bg {
        background-color: #fff;
    }


    .form-control {
        display: block;
        height: 50px;
        margin-right: 0.5rem;
        text-align: center;
        font-size: 1.25rem;
        min-width: 0;

    }

    @media (max-width: 1199.98px) {
        .authentication-cover .authentication-image-model {
            position: relative;
            width: 575px;
            top: 6rem;
        }
    }

    @media (max-width: 768px) {
    .full_loader
      {
    min-width:5vw !important;
  }
  }
  .full_loader
      {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
      }
</style>

<body>
    <div class="full_loader" ></div>
    <div class="authentication-wrapper authentication-cover">
        <!-- Logo -->
        <a href="index.html" class="auth-cover-brand d-flex align-items-center gap-2">
            <span class="app-brand-logo demo">
                <span style="color:var(--bs-primary);">

                    <img src="{{ url($webLogo_) }}" width="30" height="30">
                </span>
            </span>
            <span class="app-brand-text demo text-heading fw-semibold">{{env("APP_NAME")}}</span>
        </a>
        <!-- /Logo -->
        <div class="authentication-inner row m-0">
            <!-- /Left Section -->
            <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center justify-content-center p-5 pb-2">
                <div>
                    <img src="../assets/img/illustrations/auth-cover-login.png"
                        class="authentication-image-model d-none d-lg-block" alt="auth-model">
                </div>
                <img src="../assets/img/illustrations/auth-cover-mask-light.png"
                    class="scaleX-n1-rtl authentication-image d-none d-lg-block w-75" alt="">
            </div>
            <!-- /Left Section -->

            <!-- Login -->
            <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg position-relative py-sm-5 px-4 py-4">
                <div class="w-px-400 mx-auto pt-5 pt-lg-0">
                    <h4 class="mb-2">Two Step Verification 🔒</h4>
                    <p class="mb-4">We sent a verification code to your email.enter the code from the email in the
                        field below ****123</p>
                    <form id="formAuthentication" class="mb-3 fv-plugins-bootstrap5 fv-plugins-framework" action=""
                        novalidate="novalidate">
                        <div class="d-flex mb-3">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                            <input type="text" maxlength="1" name="code[]" pattern="[0-9]" class="form-control">
                        </div>
                        <div class="btn-container d-flex" style="position: relative">
                            <button class="btn btn-primary d-grid w-100 waves-effect waves-light" id="submit">
                                Verify my account
                            </button>
                               
                        </div>
                    </form>
                    {{-- <p class="text-center mt-2">
                        <span>Didn't get the code?</span>
                        <a href="" id="resend_submit">
                            <span>Resend</span>
                        </a>
                    </p> --}}
                    <div class="divider my-4">
                        <div class="divider-text">or</div>
                    </div>
                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:;"
                            class="btn btn-icon btn-lg rounded-pill btn-text-facebook waves-effect waves-light">
                            <i class="tf-icons mdi mdi-24px mdi-facebook"></i>
                        </a>
                        <a href="javascript:;"
                            class="btn btn-icon btn-lg rounded-pill btn-text-google-plus waves-effect waves-light">
                            <i class="tf-icons mdi mdi-24px mdi-google"></i>
                        </a>
                    </div>
                </div>
            </div>
            <!-- /Login -->
        </div>
    </div>


    <script src="../assets/vendor/libs/jquery/jquery.js"></script>
    <script src="../assets/vendor/libs/popper/popper.js"></script>
    <script src="../assets/vendor/js/bootstrap.js"></script>
    <script src="../assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="../assets/vendor/js/menu.js"></script>
    <!-- endbuild -->
    <!-- Vendors JS -->
    <script src="../assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <!-- Main JS -->
    <script src="../assets/js/main.js"></script>
    <!-- Page JS -->
    <script src="../assets/js/dashboards-analytics.js"></script>
    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
  $(document).ready(function() {
    $('.full_loader').addClass('d-none');
    function loader(show) {
      if (show) {
          $('.full_loader').removeClass('d-none');
      } else {
          $('.full_loader').addClass('d-none');
      }
  }
      $('#submit').on('click', function(e) {
          e.preventDefault();
          loader(true);

          var formData = $('form').serializeArray();
        var codes = $.map(formData, function(obj) {
            if (obj.name === 'code[]') {
                return obj.value;
            }
        });

          $.ajax({
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
              type: "POST",
              url: "{{ url('/api/verify-2fa') }}",
            //   data: $('form').serializeArray(),
            data: { 'code': codes.join('') }, 
              success: function(response) {
                loader(false);
                  toastr.success(response.message);
                  if (response.redirect_url) {
                    window.location.href = response.redirect_url;
                } else {
                    window.location.href = '{{ url('/') }}/dashboard';
                }
              },
              error: function(response) {
                loader(false);
                  if (response.status == 422) {
                      var errors = response.responseJSON.data;
                      $.each(errors, function(field, messages) {
                          error_msg = messages[0];
                          toastr.error(error_msg);
                      });
                  } else if (response.status == 500) {
                      toastr.error("Something went wrong");
                  } else {
                      toastr.error(response.responseJSON.message);
                  }
              }
          });
      });

  });
</script>

<script>
     $(document).ready(function() {
      $('#resend_submit').on('click', function(e) {
          e.preventDefault();

          $.ajax({
              headers: {
                  "Accept": "application/json"
              },
              type: "POST",
              url: "{{ url('api/resend-OTP') }}",
              data: $('form').serializeArray(),
              success: function(response) {
                  toastr.success(response.message);
                //   window.location.href = "{{ url('/') }}/account-verification";
              },
              error: function(response) {
                  if (response.status == 422) {
                      var errors = response.responseJSON.data;
                      $.each(errors, function(field, messages) {
                          error_msg = messages[0];
                          toastr.error(error_msg);
                      });
                  } else if (response.status == 500) {
                      toastr.error("Something went wrong");
                  } else {
                      toastr.error(response.responseJSON.message);
                  }
              }
          });
      });
    });
</script>

    <script>
        const form = document.querySelector('form')
        const inputs = form.querySelectorAll('input')
        const KEYBOARDS = {
            backspace: 8,
            arrowLeft: 37,
            arrowRight: 39,
        }

        function handleInput(e) {
            const input = e.target
            const nextInput = input.nextElementSibling
            if (nextInput && input.value) {
                nextInput.focus()
                if (nextInput.value) {
                    nextInput.select()
                }
            }
        }

        function handlePaste(e) {
            e.preventDefault()
            const paste = e.clipboardData.getData('text')
            inputs.forEach((input, i) => {
                input.value = paste[i] || ''
            })
        }

        function handleBackspace(e) {
            const input = e.target
            if (input.value) {
                input.value = ''
                return
            }

            input.previousElementSibling.focus()
        }

        function handleArrowLeft(e) {
            const previousInput = e.target.previousElementSibling
            if (!previousInput) return
            previousInput.focus()
        }

        function handleArrowRight(e) {
            const nextInput = e.target.nextElementSibling
            if (!nextInput) return
            nextInput.focus()
        }

        form.addEventListener('input', handleInput)
        inputs[0].addEventListener('paste', handlePaste)

        inputs.forEach(input => {
            input.addEventListener('focus', e => {
                setTimeout(() => {
                    e.target.select()
                }, 0)
            })

            input.addEventListener('keydown', e => {
                switch (e.keyCode) {
                    case KEYBOARDS.backspace:
                        handleBackspace(e)
                        break
                    case KEYBOARDS.arrowLeft:
                        handleArrowLeft(e)
                        break
                    case KEYBOARDS.arrowRight:
                        handleArrowRight(e)
                        break
                    default:
                }
            })
        })
    </script>
</body>

</html>
