@extends('includes/layout')
@section('main-page-content')

<style>
      @media (max-width: 768px) {
    .full_loader
      {
    min-width:5vw !important;
  }
  }
  .full_loader
      {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
      }
</style>
<div class="full_loader"></div>
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="card mb-4">
        <div class="card-body">
            <div class="border-bottom py-2 d-flex justify-content-between align-items-center">
                <div>
                    <div class="h4 pb-0 mb-0">Update Password</div>
                    <small>Update Password</small>
                </div>
            </div>
        </div>

        <div class="d-flex col-12">
            <div class="w-px-400 mx-auto pt-5 pt-lg-0 d-flex flex-column align-items-center">
                <h4 class="mb-2">Update Your Password 🔒</h4>
                <form id="formAuthentication" class="mb-3 " action="" novalidate="novalidate">
                    <div class="btn-container d-flex flex-column align-items-center" style="position: relative">
                        <input type="hidden" name="user_id" id="user_id" value="{{ auth()->id() }}">
                        <div class="input-group input-group-merge mb-3">
                            <div class="form-floating form-floating-outline">
                                <input type="password" id="old_password" class="form-control remember_password" name="old_password"
                                    placeholder="············" aria-describedby="password"  value="">
                                <label for="old_password">Old Password</label>
                            </div>
                            <span class="input-group-text cursor-pointer"><i
                                    class="mdi mdi-eye-off-outline"></i></span>
                        </div>
                        <div class="input-group input-group-merge mb-3">
                            <div class="form-floating form-floating-outline">
                                <input type="password" id="new_password" class="form-control" name="new_password"
                                    placeholder="············" aria-describedby="password"  value="">
                                <label for="new_password">New Password</label>
                            </div>
                            <span class="input-group-text cursor-pointer"><i
                                    class="mdi mdi-eye-off-outline"></i></span>
                        </div>
                        <div class="input-group input-group-merge mb-3">
                            <div class="form-floating form-floating-outline">
                                <input type="password" id="confirm_password" class="form-control" name="confirm_password"
                                    placeholder="············" aria-describedby="password"  value="">
                                <label for="confirm_password">Confirm Password</label>
                            </div>
                            <span class="input-group-text cursor-pointer"><i
                                    class="mdi mdi-eye-off-outline"></i></span>
                        </div>
                        <div class="btn-container d-flex" style="position: relative">
                        <button class="btn btn-primary d-grid w-100 waves-effect waves-light" id="submit">
                            Update Password
                        </button>
                        
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@endsection
@section('css-js')


    <script>
   $(document).ready(function() {
    $('.full_loader').addClass('d-none');

    function loader(show) {
      if (show) {
          $('.full_loader').removeClass('d-none');
      } else {
          $('.full_loader').addClass('d-none');
      }
    }
    $("#submit").on("click", function(e) {
        e.preventDefault();
        loader(true);
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            type: "POST",
            url: "{{url('api/update-profile-password')}}",
            data: {
                "old_password": $("#old_password").val(),
                "new_password": $("#new_password").val(),
                "confirm_password": $("#confirm_password").val(),
                "user_id": $("#user_id").val(),
            },
            success: function(response) {
                loader(false);
                toastr.success(response.message);

                $('#formAuthentication')[0].reset();
            },
            error: function(response) {
                if (response.status == 422) {
                    loader(false);
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                   
                } else if (response.status == 500) {
                    loader(false);
                    toastr.error("Something went wrong");
                } else {
                    loader(false);
                    toastr.error(response.responseJSON.message);
                }
            },
        });
    });


});


</script>
<script>
    $(document).ready(function () {
        
        function togglePasswordVisibility(inputField, eyeIconElement) {
            var passwordInput = $("#" + inputField);

            if (passwordInput.attr("type") === "password") {
                passwordInput.attr("type", "text");
                eyeIconElement.removeClass("mdi-eye-off-outline").addClass("mdi-eye-outline");
            } else {
                passwordInput.attr("type", "password");
                eyeIconElement.removeClass("mdi-eye-outline").addClass("mdi-eye-off-outline");
            }
        }
        $(".input-group-text").on("click", function () {
            var inputFieldId = $(this).siblings("div").find("input").attr("id");
            var eyeIconElement = $(this).find("i");
            togglePasswordVisibility(inputFieldId, eyeIconElement);
        });
    });
    </script>

@endsection