@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\Route;
  $settings_ = DB::table('settings')->get();
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{$subject}}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
      background-color: #f8fafc;
      padding: 20px 0;
      line-height: 1.6;
    }
    
    .email-container {
      max-width: 600px;
      margin: 0 auto;
      background: #ffffff;
      border-radius: 12px;
      box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
      overflow: hidden;
    }
    
    .header {
      background: #3b82f6;
      padding: 30px 20px;
      text-align: center;
    }
    
    .header img {
      height: 50px;
      width: auto;
      filter: brightness(0) invert(1);
    }
    
    .content {
      padding: 40px 30px;
    }
    
    .greeting {
      font-size: 20px;
      font-weight: 600;
      color: #1f2937;
      margin-bottom: 25px;
    }
    
    .greeting .name {
      color: #3b82f6;
    }
    
    .status-box {
      background: #f8fafc;
      border: 2px solid #e2e8f0;
      border-radius: 8px;
      padding: 25px;
      margin: 25px 0;
      text-align: center;
    }
    
    .status-title {
      font-size: 18px;
      font-weight: 600;
      color: #1f2937;
      margin-bottom: 10px;
    }
    
    .status-approved {
      border-color: #10b981;
      background: #f0fdf4;
    }
    
    .status-unpaid {
      border-color: #f59e0b;
      background: #fffbeb;
    }
    
    .status-rejected {
      border-color: #ef4444;
      background: #fef2f2;
    }
    
    .status-text {
      font-size: 16px;
      color: #4b5563;
    }
    
    .reason-box {
      background: #fef2f2;
      border: 1px solid #fecaca;
      border-radius: 8px;
      padding: 20px;
      margin: 20px 0;
    }
    
    .reason-title {
      font-size: 16px;
      font-weight: 600;
      color: #dc2626;
      margin-bottom: 10px;
    }
    
    .reason-content {
      font-size: 15px;
      color: #7f1d1d;
      background: white;
      padding: 15px;
      border-radius: 6px;
      border-left: 3px solid #f87171;
    }
    
    .divider {
      height: 1px;
      background: #e5e7eb;
      margin: 30px 0;
    }
    
    .thank-you {
      text-align: center;
      font-size: 18px;
      font-weight: 600;
      color: #3b82f6;
      margin: 30px 0 20px 0;
    }
    
    .contact-info {
      text-align: center;
      font-size: 14px;
      color: #6b7280;
      margin-bottom: 20px;
    }
    
    .footer {
      background: #1f2937;
      padding: 25px 20px;
      text-align: center;
      color: white;
    }
    
    .company-logo {
      height: 35px;
      width: auto;
      filter: brightness(0) invert(1);
      margin-bottom: 15px;
    }
    
    .company-name {
      font-size: 16px;
      font-weight: 600;
      margin-bottom: 10px;
    }
    
    .company-details {
      font-size: 14px;
      color: #d1d5db;
      line-height: 1.5;
    }
    
    @media (max-width: 600px) {
      .email-container {
        margin: 0 10px;
        border-radius: 8px;
      }
      
      .content {
        padding: 30px 20px;
      }
      
      .header {
        padding: 25px 15px;
      }
    }
  </style>
</head>
<body>
  <div class="email-container">
    <div class="header">
   <img src="{{url('/gtech-logo.jpeg')}}" alt="Company Logo">
    </div>
    
    <div class="content">
      <div class="greeting">Hi, <span class="name">{{$name}}</span></div>
      
      <div class="status-box 
        @if($status == 1) status-approved
        @elseif($status == 4) status-unpaid
        @else status-rejected
        @endif">
        <div class="status-title">
          @if($status == 1)
            Leave Approved ✓
          @elseif($status == 4)
            Leave Approved as Unpaid
          @else
            Leave Rejected
          @endif
        </div>
        <div class="status-text">
          @if($status == 1)
            Your leave request has been approved and will be processed according to your leave package.
          @elseif($status == 4)
            Your leave is approved but will not count against your paid leave balance.
          @else
            Your leave request has been rejected. Please review the reason below.
          @endif
        </div>
      </div>
      
      @if(isset($reason) && $reason && $status == 2)
        <div class="reason-box">
          <div class="reason-title">Reason for Rejection</div>
          <div class="reason-content">{{$reason}}</div>
        </div>
      @endif
      
      @if(isset($reason) && $reason && $status == 4)
        <div class="reason-box">
          <div class="reason-title">Reason for Unpaid Approval</div>
          <div class="reason-content">{{$reason}}</div>
        </div>
      @endif
      
      <div class="divider"></div>
      
      <div class="thank-you">Thank You</div>
      
      <div class="contact-info">
        If you have any questions, please contact your manager or HR department.
      </div>
    </div>
    
    <div class="footer">
       <img src="{{url('/gtech-logo.jpeg')}}" alt="Company Logo">
      <div class="company-name">{{env("APP_NAME")}} Group Australia</div>
      <div class="company-details">
        101 Rookwood Road Yagoona – NSW 2199, Sydney, Australia<br>
        Call: 02 8005 6676
      </div>
    </div>
  </div>
</body>
</html>