@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Add Fine/Bonus</div>
                    {{-- <small>Dashboard-Fine/Bonus</small> --}}
                </div>
                <form id="siteForm" method="POST" action="{{ route('fine.store') }}">
                    @csrf
                    <div class="row mt-3">
                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_date" class="text-dark">Month of Fine<span class="text-danger">*</span></label>
                            <input type="date" name="fine_date" id="fine_date" class="form-control mt-1" required>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select class="employe_id form-select mt-1" id="employe_id" name="employee_id">
                                <option value="">--Select--</option>
                                @foreach ($get_employes as $get_employe)
                                    @if ($get_employe->EmpPersonalDetails)
                                        <option value="{{ $get_employe->id }}">
                                            {{ $get_employe->EmpPersonalDetails->first_name }}
                                            {{ $get_employe->EmpPersonalDetails->middle_name }}
                                            {{ $get_employe->EmpPersonalDetails->last_name }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_amount" class="text-dark">Fine Amount<span class="text-danger">*</span></label>
                            <input type="number" name="fine_amount" id="fine_amount" class="form-control mt-1"
                                placeholder="Enter Fine Amount" required min="0" step="0.01">
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_reason" class="text-dark">Reason<span class="text-danger">*</span></label>
                           <textarea name="fine_reason" id="fine_reason" class="form-control mt-1" placeholder="Enter Fine Reason (max 250 characters)" required maxlength="250"></textarea>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="type" class="text-dark">Type<span class="text-danger">*</span></label>
                            <select class="type form-select mt-1" id="type" name="type">
                                <option value="">--Select--</option>
                                <option value="0">Fine</option>
                                <option value="1">Bonus</option>
                               
                            </select>
                        </div>
                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
