<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
$webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);
@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="{{ url('/') }}/assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ env('APP_NAME') }}</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/fonts/materialdesignicons.css" />
    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.css" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/theme-default.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/css/demo.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="{{ url('/') }}/assets/vendor/js/helpers.js"></script>

    <script src="{{ url('/') }}/assets/js/config.js"></script>

    <style>
  .mdi:before,
    .mdi-set {
        font-size: 175px;
        color: #019FF3;
    }

    .popup-title h4 {
        font-family: Montserrat;
        font-size: 32px;
        /* font-weight: 600; */
        line-height: 39px;
        letter-spacing: 0em;
        color: #000000CC;

    }

    .popup-title p {
        font-family: Montserrat;
        font-size: 14px;
        /* font-weight: 500; */
        line-height: 26px;
        letter-spacing: 0em;
        color: #646464;

    }

    .pop-section {
        top: 300px;
        position: relative;
    }
    </style>
</head>

<body>

    <div class="authentication-wrapper authentication-cover">
        <a href="{{url('/')}}" class="auth-cover-brand d-flex align-items-center gap-2">
            <span class="app-brand-logo demo" style="background-color: #1aa9f5">
                <span style="color:var(--bs-primary);">

                    <img src="{{ url($webLogo_) }}" width="200" height="70">
                </span>
            </span>
            {{-- <span class="app-brand-text demo text-heading fw-semibold">{{env("APP_NAME")}}</span> --}}
        </a>
        <section class="pop-section">
            <div class="container">
                <div class="popup-icon text-center">
                    <span class="mdi mdi-checkbox-marked-circle-outline"></span>
                </div>
                <div class="popup-title text-center">
                    <h4>Guest User Is Successfully Added</h4>
                </div>
            </div>
        </section>
    </div>

</body>

</html>
