@extends('includes/layout')
@section('main-page-content')
    <style>
        .bg-primary th {
            color: white;
        }

        .btn-color {
            background-color: #019FF3 !important;
        }

        .hearder-color {
            background-color: #019FF3 !important;
        }

        @media (max-width: 768px) {
            .full_loader {
                min-width: 5vw !important;
            }
        }

        .full_loader {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body p-0">
                <div class="leave-package py-2 px-3 justify-content-between align-items-center">
                    <div class="me-auto">
                        <div class="h4 pb-0 mb-0">Leave Package</div>
                        <small class="leave_pkg_small">Leave Management / Leave Package</small>
                    </div>
                    <div class="leave-type pt-2 pt-md-0 justify-content-end align-items-center">
                        <div class="p-2 align-items-center ">
                            <label class="pe-2">Search:</label>
                            <input type="text" class="form-control" id="search_data">
                        </div>
                        <div class="pt-2 mt-4 pb-2 text-start ps-2">
                            @if (in_array('Leave Package Maintain', Session::get('permissions')))
                                <button class="btn btn-primary px-3"
                                    onclick="window.location='{{ route('leavepackage.create') }}'"><span
                                        class="mdi mdi-plus"></span>Add Package</button>
                            @endif
                        </div>

                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr class="bg-primary">
                                    <th style="width: 10%;">S/N</th>
                                    <th>Title</th>
                                    <th>Leave Type</th>
                                    <th>Leave Days</th>
                                    <!-- <th>Paid/Unpaid</th> -->
                                    <th>Color</th>
                                    <th>Renew On</th>
                                    <th style="width: 10%;">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-end pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="leave-package-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {
            $("#search_data").on("keyup", function() {
                var searchText = $(this).val().toLowerCase();
                var $tableRows = $(".table-body tr");
                $tableRows.hide();
                $tableRows.filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchText) > -1;
                }).show();
                if ($tableRows.filter(":visible").length === 0) {
                    $(".table-body").append(
                        '<tr><td colspan="8" class="text-center">Records Not found</td></tr>');
                } else {
                    $(".table-body tr:contains('Records Not found')").remove();
                }
            });
        });
    </script>
    <script>
        function formatDate(dateString) {
            // Assuming dateString is in the format "yyyy-mm-dd"
            const parts = dateString.split('-');
            const formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
            return formattedDate;
        }
    </script>

    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);

        });

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {
            // loader(true);

            $.ajax({
                type: "GET",
                url: `{{ url('api/leavepackage-get') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    console.log(response);
                    var leavepackages = response.data.leavepackages;
                    console.log(leavepackages);
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                </li>
                                      <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                        <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                      </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                  <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>
                                `;
                        }

                    }

                    pages_btn += `

                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                </li>
                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                </li>
                `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < leavepackages.length; i++) {

                        var holidaycount = i + 1;

                        html += `
                    <tr>
                        <td><span class="fw-medium">${holidaycount}</span></td>
                        <td>${leavepackages[i].title ? leavepackages[i].title : ''}</td>
                        <td>${leavepackages[i].leave_type ? leavepackages[i].leave_type.title : ''}</td>
                        <td>${leavepackages[i].leave_number ? leavepackages[i].leave_number : ''}</td>
                        <!-- <td>${leavepackages[i].is_paid == 1 ? 'Paid' : 'Unpaid'}</td> -->
                        <td><div class="h-px-18 w-px-18" style="background-color: ${leavepackages[i].color_code || ''}"></div></td>
                        <td>${leavepackages[i].renew_on ? formatDate(leavepackages[i].renew_on) : ''}</td>
                              <td>
                              @if (in_array('Leave Package Maintain', Session::get('permissions')))
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${leavepackages[i].id}"  onclick="window.location='/leavepackage/${leavepackages[i]?.id}/edit'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${leavepackages[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              </ul>
                              </div>
                              @endif
                            </td>
                    </tr>`;
                    }

                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#leave-package-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "POST",
                url: "api/leavepackage-delete/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    location.reload();
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Failed to delete Leave Package");
                }
            });
        }
    </script>

    <style>
        .leave-package {
            display: flex;
        }

        .leave-type {
            display: flex;
        }

        @media only screen and (min-width: 280px) and (max-width: 430px) {
            .leave-package {
                display: block;
            }

            .leave-type {
                display: block;
            }
        }
    </style>
@endsection
