@extends('includes/layout')
@section('main-page-content')
    <style>
        .borde-color th {
            color: white;
        }

        .btn-color {
            background-color: #019FF3 !important;
        }

        .hearder-color {
            background-color: #019FF3 !important;
        }

        .border_round {
            border-radius: 6px;
            width: 48px;
            color: #019FF3;
            line-height: 12px;
            font-weight: 400;
            height: 35px;
        }
        @media (max-width: 768px) {
        .full_loader
        {
        min-width:5vw !important;
        }
        }
        .full_loader
        {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
        }
    </style>
     <div class="full_loader"></div>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-8 col-12">
                <div class="card mb-4">
                    <div class="card-body p-0">
                        <div class="gtech-profile py-3  d-flex justify-content-between align-items-center text-center">
                            <div class="me-auto">
                                <div class="d-flex align-items-center">
                                    <div class="border rounded-circle w-px-50 h-px-50">
                                        <img src="{{ asset($emp_details->EmpPersonalDetails->image) }}" alt=""
                                            class="w-px-50 h-px-50 rounded-circle">
                                    </div>
                                    <div>
                                        <span class="fw-medium ms-2">{{$emp_details->EmpPersonalDetails->first_name}} {{$emp_details->EmpPersonalDetails->middle_name ? $emp_details->EmpPersonalDetails->middle_name : ''}} {{$emp_details->EmpPersonalDetails->last_name}}</span>
                                        <div class="ms-2">{{$emp_role->title}}</div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end align-items-center border-start">

                                <div class="p-3">
                                @if(in_array('Leave Request Maintain',Session::get('permissions')))
                                    @if($leave_request->status == 1)
                                    <span class="badge rounded-pill bg-label-success me-1">Approved</span>
                                    @elseif($leave_request->status == 2)
                                    <span class="badge rounded-pill bg-label-danger me-1">Rejected</span>
                                    @elseif($leave_request->status == 3)
                                    <span class="badge rounded-pill bg-label-warning me-1">Expired</span>
                                    @elseif($leave_request->status == 4)
                                    <span class="badge rounded-pill bg-label-warning me-1">Approved as Unpaid</span>
                                    @else
                                    <span class="badge rounded-pill bg-label-info me-1">Pending</span>
                                    @endif

                                @endif
                                        <div>{{ \Carbon\Carbon::parse($leave_request->created_at)->format('d F, Y') }}</div>
                                </div>

                            </div>
                        </div>
                        <div>
                            <div class="">
                                <div class="bg-primary">
                                    <div class="calender d-flex justify-content-center align-items-center py-2">
                                        <div>
                                            <div class="d-flex align-items-center bg-white text-center border_round">
                                                {{ \Carbon\Carbon::parse($leave_request->from)->format('d M') }}
                                            </div>
                                        </div>
                                      <span class="px-2 text-white"> {{ \Carbon\Carbon::parse($leave_request->from)->format('D') }}</span>
                                      <h6 class="text-white mb-0 d-flex align-items-center">-----------------></h6>
                                      <span  class="px-2 text-white">{{ \Carbon\Carbon::parse($leave_request->to)->format('D') }}</span>
                                        <div>
                                            <div class="d-flex align-items-center bg-white text-center border_round">
                                                {{ \Carbon\Carbon::parse( $leave_request->to)->format('d M') }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="p-5">
                                    <div class="rounded h-px-250 " style="border: 1px solid gainsboro;">
                                        <div class="head rounded-top h-px-40 text-white" style="background-color: #C4C4C5;">
                                            <div class="d-flex justify-content-between p-2">
                                                <h6>{{$leave_pgk->title}}</h6>
                                                <div>
                                                    <?php
                                                    $leave_request_from = $leave_request->from;
                                                    $leave_request_to = $leave_request->to;

                                                    $start_date = new DateTime($leave_request_from);
                                                    $end_date = new DateTime($leave_request_to);
                                                    $interval = $start_date->diff($end_date);

                                                    $total_days = $interval->days + 1;
                                                    ?>
                                                </div>

                                                <div>{{ $total_days . ' days'}}</div>
                                            </div>
                                        </div>
                                        <div class="p-2 h-px-200 overflow-auto">{{$leave_request->reason}}</div>
                                    </div>
                                    <div class="leave-badges mt-3">
                                        @foreach($all_pkgs as $all_pkg)
                                        @php
                                            $color_code = $all_pkg->color_code;
                                            $linear_gradient_start = 'rgba(0, 0, 0, 0.15)';
                                            $linear_gradient_end = 'rgba(0, 0, 0, 0.15)';
                                            $text_color = '#fff';

                                            $count = DB::table('leave_requests')->where('leave_package_id',$all_pkg->id)->where('employee_id',$emp_details->id)->where('status',1)->sum('number_of_leaves');
                                        @endphp

                                        @if ($color_code)
                                            @php
                                                list($r, $g, $b) = sscanf($color_code, "#%02x%02x%02x");
                                                $linear_gradient_start = "rgba($r, $g, $b, 0.15)";
                                                $linear_gradient_end = "rgba($r, $g, $b, 0.15)";
                                                $text_color = "$color_code";
                                            @endphp
                                        @endif
                                        <span class="urgent-leave-badge badge p-2 px-3" style="{{ 'background: linear-gradient(0deg, ' . $linear_gradient_start . ', ' . $linear_gradient_end . '); color: ' . $text_color . ';' }}">
                                         {{$count}}  / {{$all_pkg->leave_number}} {{$all_pkg->title}}
                                        </span>
                                    @endforeach
                                    </div>
                                </div>
                                <div class="border-top"></div>
                                @if($leave_request->status == 0)
                                <div class="mt-2 px-5 py-3">
                                    <button class="btn btn-primary" value="1" onclick="update_leave_status({{$leave_request->id}}, 1);">APPROVE AS PAID</button>
                                    <button class="btn btn-warning" value="4" onclick="update_leave_status({{$leave_request->id}}, 4);">APPROVE AS UNPAID</button>
                                    @if($total_days > 1)
                                    <button class="btn btn-success" type="button" onclick="openCustomApproveModal({{$leave_request->id}}, {{$total_days}});">CUSTOM APPROVE</button>
                                    @endif
                                    <button class="btn btn-outline-danger" value="2" type="button" onclick="openRejectModal({{$leave_request->id}})">Rejected</button>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-4 col-12 px-4">
                <div class="card mb-4">
                    <div class="card-body p-0">
                        <div class="p-3 d-flex align-items-center border-bottom">
                            <div>
                                <span class="mdi mdi-account rounded-1"></span>
                            </div>
                            <div class="h4 mb-0 ms-4">Who's on Leave</div>
                        </div>
                        <div>
                            @if(!$today_on_leave_employes->isEmpty())
                            <div class="p-3">

                                <div>Today</div>
                                @foreach($today_on_leave_employes as $today_on_leave_employe)
                                <div class="d-flex align-items-center my-2">
                                    <div class="border rounded-circle w-px-30 h-px-30">
                                        <img src="{{ asset($today_on_leave_employe->image) }}" alt=""
                                            class="w-px-30 h-px-30 rounded-circle">
                                    </div>
                                    <div>
                                        <span class="fw-medium  ms-2" style="font-size: 12px;">{{$today_on_leave_employe->first_name}} {{$today_on_leave_employe->middle_name ? $today_on_leave_employe->middle_name : ''}} {{$today_on_leave_employe->middle_name}}</span>
                                        <div class="ms-2 fs-tiny">{{$today_on_leave_employe->title}}</div>
                                    </div>
                                </div>
                                @endforeach

                            </div>
                            @else
                            <div class="text-center p-2">No One Leave On Today</div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Custom Approve Modal -->
    <div class="modal fade" id="customApproveModal" tabindex="-1" aria-labelledby="customApproveLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="customApproveLabel">Custom Approve Leave</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" id="custom_approve_leave_id" value="">
            <div class="mb-3">
              <label for="paid_days" class="form-label">Number of paid leave days</label>
              <input type="number" min="0" class="form-control" id="paid_days" placeholder="e.g. 1">
              <div class="form-text" id="paid_days_help">Max: <span id="paid_days_max"></span></div>
            </div>
            <div class="mb-3">
              <label for="custom_reason" class="form-label">Reason (optional)</label>
              <textarea id="custom_reason" class="form-control" rows="3" placeholder="Reason for custom approval"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="button" class="btn btn-primary" onclick="submitCustomApprove()">Submit</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="rejectLabel">Reject Leave</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <input type="hidden" id="reject_leave_id" value="">
            <div class="mb-3">
              <label for="reject_reason" class="form-label">Reason for Rejection</label>
              <textarea id="reject_reason" class="form-control" rows="3" placeholder="Type reason"></textarea>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="button" class="btn btn-danger" onclick="submitReject()">Reject</button>
          </div>
        </div>
      </div>
    </div>
@endsection
@section('css-js')
<script>
   function loader(show) {
      if (show) {
          $('.full_loader').removeClass('d-none');
      } else {
          $('.full_loader').addClass('d-none');
      }
   }
   $(document).ready(function() {
      $('.full_loader').addClass('d-none');
   });
   function update_leave_status(id, status) {
    loader(true);
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        type: "PUT",
        url: "/api/leave-request/" + id + "/update-status",
        data: {
            status: status
        },
        success: function(response) {
            loader(false);
            toastr.success(response.message);
            const params = new URLSearchParams(window.location.search);
            const fromParam = params.get('from') || 0;
            window.location.href = "{{ url('/leave-request') }}?from=" + fromParam;
        },
        error: function(response) {
            loader(false);
            if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message);
            }
        }
    });
}

function openCustomApproveModal(id, maxDays) {
    $('#custom_approve_leave_id').val(id);
    $('#paid_days').val('');
    $('#paid_days').attr('max', maxDays);
    $('#paid_days_max').text(maxDays);
    var modalEl = document.getElementById('customApproveModal');
    var modal = new bootstrap.Modal(modalEl);
    modal.show();
}

function submitCustomApprove() {
    var id = $('#custom_approve_leave_id').val();
    var paidDays = parseInt($('#paid_days').val() || 0, 10);
    var max = parseInt($('#paid_days').attr('max'), 10);
    var reason = $('#custom_reason').val();
    if (isNaN(paidDays) || paidDays < 0 || paidDays > max) {
        toastr.error('Paid days must be between 0 and ' + max + '.');
        return;
    }
    loader(true);
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        type: "PUT",
        url: "/api/leave-request/" + id + "/custom-approve",
        data: {
            paid_days: paidDays,
            reason: reason
        },
        success: function(response) {
            loader(false);
            toastr.success(response.message);
            const params = new URLSearchParams(window.location.search);
            const fromParam = params.get('from') || 0;
            window.location.href = "{{ url('/leave-request') }}?from=" + fromParam;
        },
        error: function(response) {
            loader(false);
            if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message);
            }
        }
    });
}

function openRejectModal(id) {
    $('#reject_leave_id').val(id);
    $('#reject_reason').val('');
    var modalEl = document.getElementById('rejectModal');
    var modal = new bootstrap.Modal(modalEl);
    modal.show();
}

function submitReject() {
    var id = $('#reject_leave_id').val();
    var reason = $('#reject_reason').val();
    loader(true);
    $.ajax({
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        type: "PUT",
        url: "/api/leave-request/" + id + "/update-status",
        data: {
            status: 2,
            reason: reason
        },
        success: function(response) {
            loader(false);
            toastr.success(response.message);
            const params = new URLSearchParams(window.location.search);
            const fromParam = params.get('from') || 0;
            window.location.href = "{{ url('/leave-request') }}?from=" + fromParam;
        },
        error: function(response) {
            loader(false);
            if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message);
            }
        }
    });
}

</script>

<style>
    .gtech-profile{
     padding-right: 3rem !important;
    padding-left: 3rem !important;
}
.bg-primary{
    height: 52px;
}
@media only screen and (max-width: 280px){
    .gtech-profile {
    padding-right: 0rem !important;
    padding-left: 0.5rem !important;
}
.calender{
    padding: 8px 6px 8px 6px;
}
.bg-primary{
    height: 100px;
}
}
@media only screen and (min-width: 320px) and (max-width: 375px) {
    .gtech-profile{
     padding-right: 3rem !important;
    padding-left: 2rem !important;
}
.calender{
    padding: 8px 6px 8px 6px;
}
.leave-badges{
    text-align: center;
}
.urgent-leave-badge{
    margin-top: 11px;
}
}
</style>







@endsection
