@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Add Pay Roll</div>
                    <small>Dashboard-Pay Roll</small>
                </div>
                <form id="siteForm" method="POST" action="{{ route('payroll.store') }}">
                    @csrf
                    <div class="row mt-3">
                        <div class="col-md-4 form-group mb-3">
                            <label for="pay_year" class="text-dark">Select Year of Pay<span
                                    class="text-danger">*</span></label>
                            <select name="pay_year" id="pay_year" class="form-control mt-1" required>
                                <option value="">--Select--</option>
                                <script>
                                    const currentYear = new Date().getFullYear();
                                    for (let year = currentYear; year > currentYear - 10; year--) {
                                        document.write('<option value="' + year + '">' + year + '</option>');
                                    }
                                </script>
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="pay_month" class="text-dark">Select Month of Pay<span
                                    class="text-danger">*</span></label>
                            <select name="pay_month" id="pay_month" class="form-control mt-1" required>
                                <option value="">--Select--</option>
                                <option value="1">January</option>
                                <option value="2">February</option>
                                <option value="3">March</option>
                                <option value="4">April</option>
                                <option value="5">May</option>
                                <option value="6">June</option>
                                <option value="7">July</option>
                                <option value="8">August</option>
                                <option value="9">September</option>
                                <option value="10">October</option>
                                <option value="11">November</option>
                                <option value="12">December</option>
                            </select>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select class="employe_id form-select mt-1" id="employe_id" name="employee_id">
                                <option value="">--Select--</option>
                                @foreach ($get_employes as $get_employe)
                                    @if ($get_employe->EmpPersonalDetails)
                                        <option value="{{ $get_employe->id }}">
                                            {{ $get_employe->EmpPersonalDetails->first_name }}
                                            {{ $get_employe->EmpPersonalDetails->middle_name }}
                                            {{ $get_employe->EmpPersonalDetails->last_name }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="basic_salary" class="text-dark">Basic Salary<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="basic_salary" id="basic_salary" class="form-control mt-1"
                                placeholder="Enter Basic Salary" required min="0" step="0.01">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="working_hours" class="text-dark">Working Hours<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="working_hours" id="working_hours" class="form-control mt-1"
                                placeholder="Enter Working Hours" required min="0" step="0.01">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <button type="button" class="btn btn-primary mt-4"
                                onclick="fetchAttendanceAndCalculate()">Calculate Salary</button>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="hours_spended" class="text-dark">Hours Spended<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="hours_spended" id="hours_spended" readonly class="form-control mt-1"
                                placeholder="Enter Working Hours" required min="0" step="0.01">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="calculated_salary" class="text-dark">Calculated Salary<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="calculated_salary" id="calculated_salary" readonly class="form-control mt-1"
                                placeholder="Enter Working Hours" required min="0" step="0.01">
                        </div>

                        <div class="col-md-12 p-3 py-2">
                            <div id="map" class="shadow rounded" style="height: 450px;"></div>
                        </div>

                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        function fetchAttendanceAndCalculate() {
            const employeeId = document.getElementById('employe_id')
                .value; // Ensure this ID matches your actual input field's ID
            const year = document.getElementById('pay_year').value;
            const month = document.getElementById('pay_month').value;

            if (!employeeId || !year || !month) {
                alert('Please select all required options: Employee, Year, and Month.');
                return;
            }

            // Update URL to your actual API endpoint
            $.ajax({
                url: '/api/get-attendance',
                type: 'GET',
                data: {
                    employee_id: employeeId,
                    year: year,
                    month: month
                },
                success: function(response) {
                    if (response.total_hours) {
                        document.getElementById('hours_spended').value = response
                            .total_hours; // Assuming 'working_hours' is your input field ID for displaying hours
                        calculateSalary(response.total_hours);
                    } else {
                        alert('No attendance data found for the selected employee and date.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching attendance data:', xhr.responseText);
                    alert('Failed to fetch attendance data. Please try again.');
                }
            });
        }

        function calculateSalary(hours) {
            const totalWorkHoursInMonth = parseFloat(document.getElementById('working_hours').value);
            const basicSalary = parseFloat(document.getElementById('basic_salary').value);

            if (isNaN(basicSalary) || basicSalary <= 0) {
                alert('Please enter a valid basic salary.');
                return;
            }

            const hourlyRate = basicSalary / totalWorkHoursInMonth;
            const totalSalaryForHoursWorked = hours * hourlyRate;

            const roundedSalary = Math.round(totalSalaryForHoursWorked);

            document.getElementById('calculated_salary').value = roundedSalary;

            console.log({
                totalWorkHoursInMonth,
                basicSalary,
                hourlyRate,
                hoursWorked: hours,
                calculatedSalary: roundedSalary
            });
        }
    </script>
@endsection
