@extends('includes/layout')

@section('main-page-content')
    <style>
        :root {
            --primary-dark: #1A2D4D;
            --secondary-dark: #2C3E50;
            --accent-dark: #34495E;
            --text-dark: #2C3E50;
            --border-light: #E8E8E8;
            --bg-light: #F8F9FA;
            --success-color: #27AE60;
            --danger-color: #E74C3C;
            --warning-color: #F39C12;
            --info-color: #3498DB;
        }

        .page-header {
            background: #1A2D4D;
            color: white;
            padding: 1.5rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }


        .page-header h4 {
            margin: 0;
            font-weight: 600;
            color: white;
        }

        .page-header small {
            opacity: 0.9;
            font-size: 0.9rem;
            color: white;
        }

        .btn-dark-custom {
            background: white;
            border: #1A2D4D;
            color: #1A2D4D;
            border-radius: 6px;
            /* padding: 0.5rem 1rem; */
            font-weight: 500;
        }

        .btn-dark-custom:hover {
            background: #2C3E50;
            border-color: #2C3E50;
            color: white;
        }

        .btn-outline-dark-custom {
            border: 2px solid #1A2D4D;
            color: #1A2D4D;
            background: white;
            border-radius: 6px;
            padding: 0.5rem 1rem;
            font-weight: 500;
        }

        .btn-outline-dark-custom:hover {
            background: #1A2D4D;
            color: white;
        }

        .summary-card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 1rem;
            transition: transform 0.2s ease;
        }

        .summary-card:hover {
            transform: translateY(-2px);
        }

        .summary-card .card-header {
            background: #1A2D4D;
            color: white;
            border-radius: 8px 8px 0 0;
            padding: 1rem;
            border: none;
        }

        .summary-card .card-body {
            padding: 1.5rem;
            text-align: center;
        }

        .summary-value {
            font-size: 1.8rem;
            font-weight: 700;
            color: #1A2D4D;
            margin: 0.5rem 0;
        }

        .summary-label {
            color: #6C757D;
            font-size: 0.9rem;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .info-card {
            border: none;
            border-radius: 8px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            margin-bottom: 1.5rem;
        }

        .info-card .card-header {
            background: #1A2D4D;
            color: white;
            border-radius: 8px 8px 0 0;
            padding: 1rem;
            border: none;
        }

        .info-card .card-header h5 {
            margin: 0;
            font-weight: 600;
            color: white;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.75rem 0;
            border-bottom: 1px solid var(--border-light);
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            font-weight: 600;
            color: #1A2D4D;
        }

        .info-value {
            color: #6C757D;
            font-weight: 500;
        }

        .attendance-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin: 1rem 0;
        }

        .attendance-item {
            background: white;
            border: 2px solid var(--border-light);
            border-radius: 8px;
            padding: 1.5rem;
            text-align: center;
            transition: all 0.2s ease;
        }

        .attendance-item:hover {
            border-color: #1A2D4D;
            transform: translateY(-2px);
        }

        .attendance-item.primary {
            border-color: #1A2D4D;
        }

        .attendance-item.success {
            border-color: var(--success-color);
        }

        .attendance-item.danger {
            border-color: var(--danger-color);
        }

        .attendance-item.info {
            border-color: var(--info-color);
        }

        .attendance-item.warning {
            border-color: rgb(11, 56, 122);
        }

        .attendance-number {
            font-size: 2rem;
            font-weight: 700;
            margin: 0.5rem 0;
        }

        .attendance-number.primary {
            color: #1A2D4D;
        }

        .attendance-number.success {
            color: var(--success-color);
        }

        .attendance-number.danger {
            color: var(--danger-color);
        }

        .attendance-number.info {
            color: var(--info-color);
        }

        .attendance-number.warning {
            color: rgb(11, 56, 122);
        }

        .attendance-label {
            color: #6C757D;
            font-size: 0.9rem;
            font-weight: 500;
        }

        .table-custom {
            /* border-radius: 8px; */
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border: none;
        }

        .table-custom thead th {
            background: #1A2D4D;
            color: white;
            font-weight: 600;
            border: none;
            padding: 1rem;
        }

        .table-custom tbody td {
            padding: 1rem;
            border-color: var(--border-light);
            vertical-align: middle;
        }

        .table-custom tbody tr:hover {
            background-color: var(--bg-light);
        }

        .badge-custom {
            padding: 0.4rem 0.8rem;
            border-radius: 20px;
            font-weight: 500;
            font-size: 0.8rem;
        }

        .badge-success {
            background: var(--success-color);
            color: white;
        }

        .badge-danger {
            background: var(--danger-color);
            color: white;
        }

        .badge-warning {
            background: var(--warning-color);
            color: white;
        }

        .badge-info {
            background: var(--info-color);
            color: white;
        }

        .section-divider {
            height: 1px;
            background: var(--border-light);
            margin: 2rem 0;
            border: none;
        }

        /* Ensure all headings are white on dark backgrounds */
        .card-header h5,
        .card-header h4,
        .card-header h3,
        .card-header h2,
        .card-header h1 {
            color: white !important;
        }

        .page-header h1,
        .page-header h2,
        .page-header h3,
        .page-header h4,
        .page-header h5,
        .page-header h6 {
            color: white !important;
        }

        @media (max-width: 768px) {
            .page-header {
                text-align: center;
            }

            .attendance-grid {
                grid-template-columns: repeat(2, 1fr);
            }

            .summary-value {
                font-size: 1.5rem;
            }
        }
        .table-responsive {
            min-height: 0vh !important;
        }
    </style>

    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Header -->
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center flex-wrap">
                <div>
                    <h4>
                        <i class="mdi mdi-file-document-outline me-2"></i>
                        Payslip Details
                    </h4>
                    <small>
                        {{ $payroll->employee->EmpPersonalDetails->first_name ?? '' }}
                        {{ $payroll->employee->EmpPersonalDetails->middle_name ?? '' }}
                        {{ $payroll->employee->EmpPersonalDetails->last_name ?? '' }}
                        - {{ date('F Y', mktime(0, 0, 0, $payroll->pay_month, 1, $payroll->pay_year)) }}
                    </small>
                </div>
                <div class="d-flex gap-2 mt-3 mt-md-0">
                    <a href="javascript:window.history.back();" class="btn btn-outline-dark-custom">
                        <i class="mdi mdi-arrow-left me-1"></i> Back
                    </a>

                    {{-- <a href="{{ route('payroll.edit', $payroll->id) }}" class="btn btn-dark-custom">
                        <i class="mdi mdi-pencil-outline me-1"></i> Edit
                    </a> --}}
                </div>
            </div>
        </div>

        <!-- Summary Cards -->
        <div class="row g-3 mb-4">
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-clock-outline me-2"></i>Hours Required
                    </div>
                    <div class="card-body">
                        <div class="summary-value">{{ number_format($payroll->working_hours / 60, 1) }}h</div>
                        <div class="summary-label">Hours Required</div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-clock-outline me-2"></i>Hours Worked
                    </div>
                    <div class="card-body">
                        <div class="summary-value">{{ number_format($payroll->actual_working_hours / 60, 1) }}h</div>
                        <div class="summary-label">Hours Worked</div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-clock-outline me-2"></i>Leave Hours
                    </div>
                    <div class="card-body">
                        <div class="summary-value">{{ $approvedLeaveHours }}h</div>
                        <div class="summary-label">Leave Worked</div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-currency-usd me-2"></i>Basic Salary
                    </div>
                    <div class="card-body">
                        <div class="summary-value">PKR {{ number_format($payroll->basic_salary, 0) }}</div>
                        <div class="summary-label">Monthly Basic</div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-calculator me-2"></i>Calculated
                    </div>
                    <div class="card-body">
                        <div class="summary-value">PKR {{ number_format($payroll->calculated_salary, 0) }}</div>
                        <div class="summary-label">Before Adjustments</div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-6">
                <div class="card summary-card">
                    <div class="card-header">
                        <i class="mdi mdi-cash-multiple me-2"></i>Final Amount
                    </div>
                    <div class="card-body">
                        <div class="summary-value">PKR {{ number_format($adjustedSalary, 0) }}</div>
                        <div class="summary-label">Net Payable</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Employee & Salary Details -->
        <div class="row g-4 mb-4">
            <div class="col-lg-6">
                <div class="card info-card">
                    <div class="card-header">
                        <h5><i class="mdi mdi-account-outline me-2"></i>Employee Information</h5>
                    </div>
                    <div class="card-body">
                        <div class="info-row">
                            <span class="info-label">Full Name</span>
                            <span class="info-value">{{ $payroll->employee->first_name ?? '' }}
                                {{ $payroll->employee->middle_name ?? '' }}
                                {{ $payroll->employee->last_name ?? '' }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Mobile Number</span>
                            <span class="info-value">{{ $payroll->employee->mobile ?? 'Not Available' }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Email Address</span>
                            <span class="info-value">{{ $payroll->employeCom->employee_email ?? 'Not Available' }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Employee ID</span>
                            <span class="info-value">#{{ $payroll->employee->id ?? 'N/A' }}</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card info-card">
                    <div class="card-header">
                        <h5><i class="mdi mdi-chart-line me-2"></i>Salary Breakdown</h5>
                    </div>
                    <div class="card-body">
                        <div class="info-row">
                            <span class="info-label">Basic Salary</span>
                            <span class="info-value">PKR {{ number_format($payroll->basic_salary, 0) }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Total Working Hours</span>
                            <span class="info-value">{{ number_format($payroll->working_hours / 60, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Hours Worked</span>
                            <span class="info-value">{{ number_format($payroll->actual_working_hours / 60, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Approved Leaves</span>
                            <span class="info-value">{{ $approvedLeave }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Approved Leave Hours</span>
                            <span class="info-value">{{ $approvedLeaveHours }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Unpaid Leave Hours</span>
                            <span class="info-value">{{ number_format($unpaidLeaveHours, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Paid Leave Hours</span>
                            <span class="info-value">{{ number_format($paidLeaveHours, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Holidays</span>
                            <span class="info-value">{{ $totalHolidays }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Overtime Hours</span>
                            <span class="info-value">{{ number_format($payroll->overtime_hours / 60, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Paid Worked Hours</span>
                            <span class="info-value">{{ number_format($paidWorkedHours, 1) }} hours</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Total Fines</span>
                            <span class="info-value text-danger">PKR {{ number_format($totalFines, 0) }}</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Total Bonuses</span>
                            <span class="info-value text-success">PKR {{ number_format($totalBonuses, 0) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <hr class="section-divider">

        <div class="card info-card mb-4">
            <div class="card-header">
                <h5><i class="mdi mdi-calendar-check me-2"></i>Attendance Summary</h5>
            </div>
            <div class="card-body">
                <div class="attendance-grid">
                    <div class="attendance-item primary">
                        <i class="mdi mdi-calendar mdi-24px mb-2" style="color: #1A2D4D;"></i>
                        <div class="attendance-number primary">{{ $totalWorkingDays }}</div>
                        <div class="attendance-label">Total Working Days</div>
                    </div>
                    <div class="attendance-item warning">
                        <i class="mdi mdi-beach mdi-24px mb-2" style="color: rgb(11, 56, 122);"></i>
                        <div class="attendance-number warning">{{ $totalHolidays }}</div>
                        <div class="attendance-label">Holidays</div>
                    </div>
                    <div class="attendance-item success">
                        <i class="mdi mdi-check-circle mdi-24px mb-2" style="color: var(--success-color);"></i>
                        <div class="attendance-number success">{{ $presentDays }}</div>
                        <div class="attendance-label">Present Days</div>
                    </div>
                    <div class="attendance-item danger">
                        <i class="mdi mdi-close-circle mdi-24px mb-2" style="color: var(--danger-color);"></i>
                        <div class="attendance-number danger">{{ $absentDays }}</div>
                        <div class="attendance-label">Absent Days</div>
                    </div>
                    <div class="attendance-item info">
                        <i class="mdi mdi-chart-donut mdi-24px mb-2" style="color: var(--info-color);"></i>
                        <div class="attendance-number info">
                            {{ $attendanceRate }}%
                        </div>
                        <div class="attendance-label">Attendance Rate</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Fines & Bonuses -->
        @if ($fines->count() > 0)
            <div class="card info-card mb-4">
                <div class="card-header">
                    <h5><i class="mdi mdi-alert-circle-outline me-2"></i>Fines & Bonuses</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-custom mb-0">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Reason</th>
                                    <th class="text-end">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($fines as $fine)
                                    <tr>
                                        <td>{{ date('d M Y', strtotime($fine->date)) }}</td>
                                        <td>
                                            @if ($fine->type == 0)
                                                <span class="badge badge-danger">Fine</span>
                                            @else
                                                <span class="badge badge-success">Bonus</span>
                                            @endif
                                        </td>
                                        <td>{{ $fine->fine_reason }}</td>
                                        <td class="text-end">
                                            <span class="{{ $fine->type == 0 ? 'text-danger' : 'text-success' }} fw-bold">
                                                {{ $fine->type == 0 ? '-' : '+' }}PKR
                                                {{ number_format($fine->fine_amount, 0) }}
                                            </span>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot style="background: var(--bg-light);">
                                <tr>
                                    <th colspan="3">Net Impact</th>
                                    <th class="text-end">
                                        <span
                                            class="{{ $totalBonuses - $totalFines >= 0 ? 'text-success' : 'text-danger' }} fw-bold">
                                            {{ $totalBonuses - $totalFines >= 0 ? '+' : '' }}PKR
                                            {{ number_format($totalBonuses - $totalFines, 0) }}
                                        </span>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        @endif

        <!-- Attendance Details -->
        @if ($attendances->count() > 0)
            <div class="card info-card mb-4">
                <div class="card-header">
                    <h5><i class="mdi mdi-clock-time-four-outline me-2"></i>Daily Attendance</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-custom mb-0">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Check In</th>
                                    <th>Check Out</th>
                                    <th class="text-end">Working Hours</th>
                                    <th class="text-center">Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($attendances as $attendance)
                                    <tr>
                                        <td>{{ date('d M Y', strtotime($attendance->date)) }}</td>
                                        <td>{{ $attendance->check_in ? date('H:i', strtotime($attendance->check_in)) : 'N/A' }}
                                        </td>
                                        <td>{{ $attendance->check_out ? date('H:i', strtotime($attendance->check_out)) : 'N/A' }}
                                        </td>
                                        <td class="text-end">
                                            @if ($attendance->working_hours)
                                                {{ floor($attendance->working_hours / 60) }}h
                                                {{ $attendance->working_hours % 60 }}m
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td class="text-center">
                                            @if ($attendance->check_in && $attendance->check_out)
                                                <span class="badge badge-success">Present</span>
                                            @elseif($attendance->check_in)
                                                <span class="badge badge-warning">Incomplete</span>
                                            @else
                                                <span class="badge badge-danger">Absent</span>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif

        <!-- Overtime Details -->
        @if ($overtimeRecords->count() > 0)
            <div class="card info-card mb-4">
                <div class="card-header">
                    <h5><i class="mdi mdi-clock-plus-outline me-2"></i>Overtime Records</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-custom mb-0">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Start Time</th>
                                    <th>End Time</th>
                                    <th class="text-end">Duration</th>
                                    <th>Reason</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($overtimeRecords as $overtime)
                                    <tr>
                                        <td>{{ date('d M Y', strtotime($overtime->date)) }}</td>
                                        <td>{{ $overtime->check_in ? date('H:i', strtotime($overtime->check_in)) : 'N/A' }}
                                        </td>
                                        <td>{{ $overtime->check_out ? date('H:i', strtotime($overtime->check_out)) : 'N/A' }}
                                        </td>
                                        <td class="text-end">
                                            @if ($overtime->working_hours)
                                                {{ floor($overtime->working_hours / 60) }}h
                                                {{ $overtime->working_hours % 60 }}m
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{ $overtime->description ?? 'No reason provided' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif

    </div>
@endsection

@section('css-js')
    <script>
        // Simple interactions for better UX
        document.addEventListener('DOMContentLoaded', function() {
            // Add smooth hover effects
            const cards = document.querySelectorAll('.summary-card, .info-card, .attendance-item');
            cards.forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transition = 'all 0.2s ease';
                });
            });
        });
    </script>
@endsection
