@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Edit Pay Roll</div>
                    <small>Dashboard-Pay Roll</small>
                </div>
                <form method="POST" action="{{ route('payroll.update', $payroll->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="row mt-3">
                        <div class="col-md-4 form-group mb-3">
                            <label for="pay_year" class="text-dark">Select Year of Pay<span
                                    class="text-danger">*</span></label>
                            <select class="form-select" id="pay_year" name="pay_year" required>
                                @for ($year = now()->year; $year >= now()->year - 10; $year--)
                                    <option value="{{ $year }}" {{ $payroll->pay_year == $year ? 'selected' : '' }}>
                                        {{ $year }}
                                    </option>
                                @endfor
                            </select>
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="pay_month" class="text-dark">Select Month of Pay<span
                                    class="text-danger">*</span></label>
                            <select class="form-select" id="pay_month" name="pay_month" required>
                                @foreach (range(1, 12) as $month)
                                    <option value="{{ $month }}"
                                        {{ $payroll->pay_month == $month ? 'selected' : '' }}>
                                        {{ DateTime::createFromFormat('!m', $month)->format('F') }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select name="employee_id" id="employee_id" class="form-control" required>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ $employee->id == $payroll->employee_id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="basic_salary" class="text-dark">Basic Salary<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="basic_salary" id="basic_salary"
                                value="{{ $payroll->basic_salary }}" class="form-control mt-1"
                                placeholder="Enter Basic Salary" required min="0" step="0.01">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="working_hours" class="text-dark">Working Hours<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="working_hours" id="working_hours"
                                value="{{ $payroll->working_hours / 60 }}" class="form-control mt-1"
                                placeholder="Enter Working Hours" required min="0" step="0.01">
                        </div>
                        {{-- <div class="col-md-4 form-group mb-3">
                            <button type="button" class="btn btn-primary mt-4" onclick="calculateSalaryFromRoster($payroll->working_hours / 60)">
                                <i class="fas fa-calculator"></i>
                            </button>
                        </div> --}}
                        <div class="col-md-4 form-group mb-3">
                            <label for="hours_spended" class="text-dark">Hours Spended<span
                                    class="text-danger">*</span></label>
                            <input type="text" name="hours_spended" id="hours_spended"
                            value="@php echo floor($payroll->hours_spent / 60) . ':' . sprintf('%02d', $payroll->hours_spent % 60); @endphp"
                            class="form-control mt-1" readonly
                            placeholder="Enter Working Hours" required min="0" step="0.01">

                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="calculated_salary" class="text-dark">Calculated Salary<span
                                    class="text-danger">*</span></label>
                            <input type="number" name="calculated_salary" id="calculated_salary"
                                value="{{ $payroll->calculated_salary }}" class="form-control mt-1" readonly
                                placeholder="Enter Working Hours" required min="0" step="0.01">
                        </div>
                        <div class="col-md-4 form-group mt-6" style="margin-top: 26px;">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                    </div>

                        <div class="col-md-12 p-3 py-2">
                            <div id="map" class="shadow rounded" style="height: 450px;"></div>
                        </div>

                    </div>
                    
                </form>

            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        function fetchAttendanceAndCalculate() {
            const employeeId = document.getElementById('employee_id').value;
            const year = document.getElementById('pay_year').value;
            const month = document.getElementById('pay_month').value;

            if (!employeeId || !year || !month) {
                alert('Please select all required options: Employee, Year, and Month.');
                return;
            }

            $.ajax({
                url: '/api/get-roster-working-hours',
                type: 'GET',
                data: {
                    employee_id: employeeId,
                    year: year,
                    month: month
                },
                success: function(response) {
                    if (response.working_hours) {
                        // Convert roster working hours from minutes to hours for display
                        const workingHoursInHours = response.working_hours / 60;
                        document.getElementById('working_hours').value = workingHoursInHours;
                        
                        // Calculate salary based on roster working hours
                        calculateSalaryFromRoster(response.working_hours);
                    } else {
                        alert('No roster data found for the selected employee and date.');
                    }
                },
                error: function(xhr, status, error) {
                    console.error('Error fetching roster data:', xhr.responseText);
                    alert('Failed to fetch roster data. Please try again.');
                }
            });
        }

        function calculateSalaryFromRoster(rosterWorkingMinutes) {
            const basicSalary = parseFloat(document.getElementById('basic_salary').value);

            if (isNaN(basicSalary) || basicSalary <= 0) {
                alert('Please enter a valid basic salary.');
                return;
            }

            if (isNaN(rosterWorkingMinutes) || rosterWorkingMinutes <= 0) {
                alert('No valid roster working hours found.');
                return;
            }

            // Calculate per-minute rate based on roster working hours (same as controller logic)
            const perMinuteRate = basicSalary / rosterWorkingMinutes;
            
            // For edit form, we'll use the actual hours spent from the payroll record
            const hoursSpendedValue = document.getElementById('hours_spended').value;
            let actualHoursSpent = 0;
            if (hoursSpendedValue.includes(':')) {
                // Parse HH:MM format
                const [hours, minutes] = hoursSpendedValue.split(':').map(Number);
                actualHoursSpent = (hours * 60) + (minutes || 0);
            } else {
                // Fallback: treat as decimal hours
                actualHoursSpent = parseFloat(hoursSpendedValue) * 60;
            }
            
            // Calculate salary based on actual hours spent and per-minute rate
            const calculatedSalary = Math.round(perMinuteRate * actualHoursSpent);
            document.getElementById('calculated_salary').value = calculatedSalary;

            console.log({
                rosterWorkingMinutes,
                basicSalary,
                perMinuteRate,
                actualHoursSpent,
                calculatedSalary: calculatedSalary
            });
        }

        // Function to recalculate when basic salary or working hours change
        function recalculateSalary() {
            const workingHoursInMinutes = parseFloat(document.getElementById('working_hours').value) * 60;
            const hoursSpendedValue = document.getElementById('hours_spended').value;
            let actualHoursSpent = 0;
            if (hoursSpendedValue.includes(':')) {
                // Parse HH:MM format
                const [hours, minutes] = hoursSpendedValue.split(':').map(Number);
                actualHoursSpent = (hours * 60) + (minutes || 0);
            } else {
                // Fallback: treat as decimal hours
                actualHoursSpent = parseFloat(hoursSpendedValue) * 60;
            }
            const basicSalary = parseFloat(document.getElementById('basic_salary').value);

            console.log(actualHoursSpent);

            if (workingHoursInMinutes > 0 && actualHoursSpent > 0 && basicSalary > 0) {
                const perMinuteRate = basicSalary / workingHoursInMinutes;
                const calculatedSalary = Math.round(perMinuteRate * actualHoursSpent);
                document.getElementById('calculated_salary').value = calculatedSalary;
            }
        }

        // Add event listeners for automatic recalculation
        document.addEventListener('DOMContentLoaded', function() {
            document.getElementById('basic_salary').addEventListener('input', recalculateSalary);
            document.getElementById('working_hours').addEventListener('input', recalculateSalary);
            document.getElementById('hours_spended').addEventListener('input', recalculateSalary);
        });
    </script>
@endsection
