<div class="tab-pane fade active show" id="navs-top-role" role="tabpanel">
    <div class=" py-3 d-flex justify-content-between align-items-center">
        <div>
            <div class="h4 pb-0 mb-0"> Employee Role</div>
            <small>Role List</small>
        </div>
        @if(in_array('Registration Setting Maintain',Session::get('permissions')))
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#AddNewEmployeeRole"><span
                class="mdi mdi-plus"></span>Add</button>
                @endif
    </div>
    <table class="table border-top  table-no-bottom-border">
        <tbody class="table-border-bottom emp_role_append">

        </tbody>
    </table>
</div>

<div class="modal fade" id="AddNewEmployeeRole" tabindex="-1" aria-labelledby="AddNewEmployeeRole" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header bg-primary px-4 py-2">
          <h5 class="modal-title text-white" id="AddNewEmployeeRoleLabel">New Employee Roles</h5>
        </div>
        <div class="modal-body">
          <div class="mb-2">
            <label for="defaultFormControlInput" class="form-label">Title</label>
            <input type="text" class="form-control" id="create-emp-role-title" placeholder="Admin" aria-describedby="defaultFormControlHelp">
          </div>
          <div class="mb-2">
            <label for="defaultFormControlInput" class="form-label">Code</label>
            <input type="text" class="form-control" id="create-emp-role-code"  aria-describedby="defaultFormControlHelp">
          </div>
        </div>
        <div class="modal-footer border-top py-2">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" onclick="_emp_role_store();">Save</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="EditEmpRole" tabindex="-1" aria-labelledby="EditEmpRoleLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header bg-primary px-4 py-2">
          <h5 class="modal-title text-white" id="EditRoleLabel">Edit Employee Roles</h5>
        </div>
        <div class="modal-body">
            <div class="mb-2">
              <label for="defaultFormControlInput" class="form-label">Title</label>
              <input type="text" class="form-control" id="edit-emp-role-title" placeholder="Admin" aria-describedby="defaultFormControlHelp">
            </div>
            <div class="mb-2">
              <label for="defaultFormControlInput" class="form-label">Code</label>
              <input type="text" class="form-control " id="edit-emp-role-code"  aria-describedby="defaultFormControlHelp">
            </div>
            <input type="hidden" class="form-control" id="edit-emp-role-id"  value="" aria-describedby="defaultFormControlHelp">

          </div>
        <div class="modal-footer border-top py-2">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" data-id="" onclick="_emp_role_update();">Save Changes</button>
        </div>
      </div>
    </div>
</div>

<div class="modal fade" id="DeleteEmpRole" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
  <div class="modal-content">
    <div class="modal-header bg-danger px-4 py-2">
      <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
    </div>
    <div class="modal-body">
      Are you sure you want to delete this record?<br><br>
      <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
    </div>
    <div class="modal-footer border-top py-2">
      <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
      <button type="button" class="btn btn-danger " id="delete-emp-role-id" data-id="" onclick="_emp_role_delete(this)">Delete</button>
    </div>
  </div>
</div>
</div>
<script>
    $(document).ready(function () {

    loader(false);
    _emp_role_get();

    });

    function _emp_role_get()
    {
        loader(true);

        $.ajax({
                    type: "GET",
                    url: "{{url('/role')}}",
                    headers: {
                        'X-CSRF-TOKEN': '{{csrf_token()}}'
                    },
                    success: function(response) {
                        _emp_role_append(response.data.roles);

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                    toastr.error("Something went wrong")
                }
                else
                {
                    toastr.error(response.responseJSON.message)
                }
                    }
        });

    }

    function _emp_role_append(data)
    {
    var html = ``;
    for(var i=0; i < data.length; i++)
    {
        html +=  `<tr>
                <td>
                    <span class="fw-medium">${data[i].title}</span>
                </td>

                <td style="width: 130px;">
                @if(in_array('Registration Setting Maintain',Session::get('permissions')))
                  <div class="dropdown cursor-pointer d-flex justify-content-center">
                  <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

                  <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                  <li><a class="dropdown-item py-1 ps-2"  data-title="${data[i].title}" data-code="${data[i].code}" data-id="${data[i].id}" onclick="_emp_role_edit(this)"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                  <li><a class="dropdown-item py-1 ps-2"  data-title="${data[i].title}" data-code="${data[i].code}" data-id="${data[i].id}"  onclick="_emp_role_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                  </ul>
                  </div>
                  @endif
                </td>
            </tr>`;
    }

        if(html == ``)
        {
        html = `<div class="w-100 text-center mt-5">
                    no employee role yet
                    </div>`;
        }


    $('.emp_role_append').html(html);
    }

    function _emp_role_create()
    {

      $('#create-emp-role-title').val('');
      $('#create-emp-role-code').val('');
    }

     function _emp_role_store()
    {
            loader(true);

              var _FormData = new FormData();
              _FormData.append("title", $('#create-emp-role-title').val());
              _FormData.append("code", $('#create-emp-role-code').val());


            $.ajax({
                        type: "POST",
                        url: "{{url('/role')}}",
                        headers: {
                            'X-CSRF-TOKEN': '{{csrf_token()}}'
                        },
                        data: _FormData,
                        processData: false,
                        contentType: false,
                        success: function(response) {
                          toastr.success(response.message);
                         _emp_role_append(response.data.roles);
                         $('#AddNewEmployeeRole').modal('hide');
                          loader(false);
                           // Reset form fields
                          $('#create-emp-role-title').val('');
                          $('#create-emp-role-code').val('');

                        },
                        error: function(response) {
                          loader(false);
                          if (response.status == 500) {
                      toastr.error("Something went wrong")
                    }
                    else
                    {
                      toastr.error(response.responseJSON.message)
                    }
                      }
            });

    }


    function _emp_role_edit(_this)
    {
      var id  =  $(_this).attr('data-id');
      var title  =  $(_this).attr('data-title');
      var code  =  $(_this).attr('data-code');

      $('#edit-emp-role-id').val(id);
      $('#edit-emp-role-title').val(title);
      $('#edit-emp-role-code').val(code);
      $('#EditEmpRole').modal('show');
    }

    function _emp_role_update()
    {
          loader(true);

      var id  =  $('#edit-emp-role-id').val();
      var title = $('#edit-emp-role-title').val();
      var code = $('#edit-emp-role-code').val();

          $.ajax({
                      type: "PUT",
                      headers: {
                          'X-CSRF-TOKEN': '{{csrf_token()}}'
                      },
                      url : `/role/${id}?title=${title}&code=${code}`,
                      success: function(response) {
                        toastr.success(response.message);
                         _emp_role_append(response.data.roles);
                         $('#EditEmpRole').modal('hide');

                          loader(false);

                      },
                      error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                    toastr.error("Something went wrong")
                  }
                  else
                  {
                    toastr.error(response.responseJSON.message)
                  }
                    }
          });

    }

    function  _emp_role_delete(_this)
    {


         var id  =  $(_this).attr('data-id');


        $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{csrf_token()}}'
                },
                type: "DELETE",
                url: "{{url('/role')}}/"+id,
                success: function(response) {
                  toastr.success(response.message);
                  _emp_role_append(response.data.roles);
                  $('#DeleteEmpRole').modal('hide');

                  loader(false);


                },
                error: function(response) {
                loader(false);
                if (response.status == 500) {
            toastr.error("Something went wrong")
            }
            else
            {
            toastr.error(response.responseJSON.message)
            }
            }
        });

    }

    function _emp_role_delete_modal(_this)
    {
      var id  =  $(_this).attr('data-id');
      $('#delete-emp-role-id').attr('data-id',id);
      $('#DeleteEmpRole').modal('show');
    }
</script>
