<input type="hidden" class="count-field" value="0" >
<div class="tab-pane fade" id="navs-top-document" role="tabpanel">
    <div class=" py-3 d-flex justify-content-between align-items-center">
        <div>
            <div class="h4 pb-0 mb-0">Required Documents</div>
            <small>Required Documents</small>
        </div>
        @if(in_array('Registration Setting Maintain',Session::get('permissions')))
        <button class="btn btn-primary bt-lg" data-bs-toggle="modal" data-bs-target="#AddDocuments" onclick="add_doc_modal();" ><span class="mdi mdi-plus"></span>Add</button>
        @endif
    </div>
    <table class="table border-top  table-no-bottom-border">
        <tbody class="table-border-bottom required_documents">

        </tbody>
    </table>
</div>

<div class="modal fade" id="delete_doc" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
        <div class="modal-header bg-danger px-4 py-2">
          <h5 class="modal-title text-white" id="deletedocLabel">Delete</h5>
      </div>
     
      <div class="modal-body">
        Are you sure you want to delete this record?<br><br>
        <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you
        genuinely want to delete it before clicking the delete button.
    </div>
    <div class="modal-footer border-top py-2">
      <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
      <button type="button" class="btn btn-danger " id="delete-doc-info-id" data-id=""
          onclick="_delete_doc(this)">Delete</button>
  </div>
    </div>
  </div>
</div>

<div class="modal fade" id="AddDocuments" tabindex="-1" aria-labelledby="AddDocuments" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="AddDocumentsLabel">Documents</h5>
            </div>
            <div class="modal-body">
                <form class="add_doc_form" >

                    <div class="mb-2">
                        <label for="defaultFormControlInput" class="form-label">Title</label>
                        <input type="text" class="form-control title" placeholder="Documents" name="title">
                    </div>

                    <div class="row mt-3">
                        <label class="form-check-label" >Select User Type</label>
                        <div class="col-3 mt-3">
                            <input class="form-check-input for_who" type="radio" value="0" name="for_who" checked >
                            <label class="form-check-label" >Internal</label>
                        </div>
                        <div class="col-3 mt-3">
                            <input class="form-check-input for_who" type="radio" value="1" name="for_who">
                            <label class="form-check-label" >External</label>
                        </div>
                        <div class="col-3 mt-3">
                            <input class="form-check-input for_who" type="radio" value="2" name="for_who">
                            <label class="form-check-label" >Both</label>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-9">
                        </div>
                        <div class="col-3 text-end">
                        Add more :  <span role="button" style="color: #1A2D4D;" class="mdi mdi-plus-circle mdi-24px ms-auto" onclick="add_more_fields('AddDocuments');" ></span>
                        </div>
                    </div>

                    <div class="mt-4 row">
                    <div class="col-1">
                            <label class="form-check-label" >Priority</label>
                        </div>
                        <div class="col-4">
                            <label class="form-check-label" >Field Name</label>
                        </div>
                        <div class="col-3">
                            <label class="form-check-label" >Type</label>
                        </div>
                        <div class="col-2 text-center">
                            <label class="form-check-label text-center" >Required</label>                       
                        </div>
                        <div class="col-2 text-center">
                            <label class="form-check-label text-center" >Remove</label>                       
                        </div>
                    </div>
                    
                    <div class="append_fields"></div>

                    <input type="hidden" class="form-control height-width" id="edit-doc-info-id" value="" >
                </form>
            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="_doc_info_store();">Save</button>
            </div>
        </div>
    </div>
</div>

    <div class="modal fade" id="EditdocInformation" tabindex="-1" aria-labelledby="EditdocInformationLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
          <div class="modal-header bg-primary px-4 py-2">
              <h5 class="modal-title text-white" id="EditRoleLabel">Edit Documents</h5>
          </div>
          <div class="modal-body">
            <form class="edit_doc_form" >

            <div class="mb-2">
                <label for="defaultFormControlInput" class="form-label">Title</label>
                <input type="text" class="form-control title" placeholder="title" name="title">
                <input type="hidden" class="document_id" name="document_id">
            </div>

            <div class="row mt-3">
                <label class="form-check-label" >Select User Type</label>
                <div class="col-3 mt-3">
                    <input class="form-check-input for_who" type="radio"  value="0" checked name="for_who">
                    <label class="form-check-label" >Internal</label>
                </div>
                <div class="col-3 mt-3">
                    <input class="form-check-input for_who" type="radio" value="1" name="for_who">
                    <label class="form-check-label" >External</label>
                </div>
                <div class="col-3 mt-3">
                    <input class="form-check-input for_who" type="radio" value="2" name="for_who">
                    <label class="form-check-label" >Both</label>
                </div>
            </div>

            <div class="row">
                <div class="col-9">
                </div>
                <div class="col-3 text-end">
                Add more :  <span role="button" style="color: #1A2D4D;" class="mdi mdi-plus-circle mdi-24px ms-auto" onclick="add_more_fields_edit('EditdocInformation');" ></span>
                </div>
            </div>

            <div class="mt-4 row">
            <div class="col-1">
                    <label class="form-check-label" >Priority</label>
                </div>
                <div class="col-3">
                    <label class="form-check-label" >Field Name</label>
                </div>
                <div class="col-2">
                    <label class="form-check-label" >Type</label>
                </div>
                <div class="col-2 text-center">
                    <label class="form-check-label text-center" >Required</label>                       
                </div>
                <div class="col-2">
                    <label class="form-check-label" >Status</label>                       
                </div>
                <div class="col-2 text-center">
                    <label class="form-check-label text-center" >Remove</label>                       
                </div>
            </div>

            <div class="append_fields_edit"></div>

            
            </form>
            </div> 
              <div class="modal-footer border-top py-2">
                  <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                  <button type="button" class="btn btn-primary" data-id=""
                      onclick="_doc_information_update();">Save Changes</button>
              </div>
          
      </div>
    </div>



    <div class="modal fade" id="DeleteDocument_information">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletedocLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger " id="delete-doc-info-id" data-id=""
                        onclick="_delete_doc(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
    <script>

        $(document).ready(function() {
            _required_documents_get();
        });

        function _doc_info_store()
        {
            loader(true);

            var _FormData = new FormData($('.add_doc_form')[0]);
            var blankFieldCount = 0;

           $('.add_doc_form .field_name').each(function() {
                if ($(this).val().trim() == '') {
                    blankFieldCount++;
                }
            });

            if (blankFieldCount != 0) {
                toastr.error("All field name are required.");
                loader(false);
                return 0;
            }

            
            $.ajax({
                type: "POST",
                url: "{{ url('/required-document') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: _FormData,
                processData: false,
                contentType: false,
                success: function(response) {
                    toastr.success(response.message);
                    _required_documents(response.data.required_documents);
                    $('#AddDocuments').modal('hide');
                    loader(false);

                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _required_documents_get()
        {       
            $.ajax({
                type: "GET",
                url: "{{ url('/required-document') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    _required_documents(response.data.required_documents);
                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _required_documents(data)
        {
            var html = ``;
            for (var i = 0; i < data.length; i++) {

                var forWho =
                data[i].for_who == 0 ? 'Internal' :
                data[i].for_who == 1 ? 'External' :
                data[i].for_who == 2 ? 'Both' : '';

                html += `<tr>
                    <td>
                        <span class="fw-medium">${data[i].title}</span>
                    </td>
                    <td>
                        <span class="fw-medium">${forWho}</span>
                    </td>
                    <td style="width: 130px;">
                    @if(in_array('Registration Setting Maintain',Session::get('permissions')))
                      <div class="dropdown cursor-pointer d-flex justify-content-center">
                      <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                      <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                      <li><a class="dropdown-item py-1 ps-2" data-title="${data[i].title}" data-id="${data[i].id}" onclick="_document_edit(this)"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                      <li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_doc_info_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                      </ul>
                      </div>
                      @endif
                    </td>
                </tr>
                `;
            }

            if (html == ``) {
                html = `<div class="w-100 text-center mt-5"> 
                    No required documents yet
                    </div>`;
            }


            $('.required_documents').html(html);
        }

        function _document_edit(_this)
        {
            $.ajax({
                type: "GET",
                url: "{{url('/required-document')}}/"+$(_this).attr('data-id')+"/edit",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                   
                    var required_documents = response.data.required_documents;
                    var required_document_field = response.data.required_documents.required_document_field;
                    $('.title').val(required_documents.title);
                    $('.for_who[value="'+required_documents.for_who+'"]').prop('checked', true);
                    $('.document_id').val(required_documents.id);
                    $('.append_fields').html('');
                    $('.count-field').val(0);
                    var _html = ``;

                    for(var i = 0; i < required_document_field.length; i++)
                    {
                      _html += `
                        <div class="mt-2 row fields_row">
                            <div class="col-1">
                                <input type="text"  onchange="if (!this.value.match(/^[1-9]$/)) { this.value = '1'; }" class="form-control mt-2 priority" value="${required_document_field[i].priority}"  name="priority[${i}]">
                            </div>
                            <div class="col-3">
                                <input type="text" class="form-control mt-2 field_name" value="${required_document_field[i].field_name}"  ${required_document_field[i].hasData != 0 ?  'readonly' : '' } style="${required_document_field[i].hasData != 0 ?  'opacity: 0.6;' : '' }"  placeholder="Field Name" name="field_name[${i}]">
                                <input type="hidden" value="${required_document_field[i].id}" name="id_list[${i}]">
                                <input type="hidden" value="${required_document_field[i].hasData}" name="has_data[${i}]">
                            </div>
                            <div class="col-2">
                                <select class="form-select mt-2 field_type"   name="field_type[${i}]"   style="${required_document_field[i].hasData != 0 ?  'pointer-events: none;opacity: 0.6;' : '' }"  >
                                    <option value="text" ${required_document_field[i].field_type == 'text' ?  'selected' : '' }>Text</option>
                                    <option value="number" ${required_document_field[i].field_type == 'number' ?  'selected' : '' }>Number</option>
                                    <option value="date" ${required_document_field[i].field_type == 'date' ?  'selected' : '' }>Date</option>
                                    <option value="file" ${required_document_field[i].field_type == 'file' ?  'selected' : '' }>Image</option>
                                </select>
                            </div>
                            <div class="col-2 text-center">
                                <input type="hidden" value="0"  name="field_required[${i}]">
                                <div class="col-12 d-flex justify-content-center align-items-center h-100"><input type="checkbox" class="form-check-input field_required" placeholder="Field Required" value="1"  ${required_document_field[i].field_required == 1 ? 'checked' : '' }  name="field_required[${i}]" ></div>
                            </div>
                            <div class="col-2">
                                <select class="form-select mt-2 status"  name="status[${i}]" >
                                    <option value="1" ${required_document_field[i].status == '1' ?  'selected' : '' }>Active</option>
                                    <option value="0" ${required_document_field[i].status == '0' ?  'selected' : '' }>InActive</option>
                                </select>
                            </div>
                            <div class="col-2 text-center">
                                <div class="col-12  d-flex justify-content-center mt-2 "><div role="button" style="color: #1A2D4D;" class="mdi mdi-close-circle mdi-24px mt-2"   data-hasdata="${required_document_field[i].hasData}" data-id="${required_document_field[i].id}"   onclick="remove_a_field_edit(this);" ></div></div>
                            </div>
                        </div>`;
                        $('.count-field').val(i+1);

                    }


                    $('.append_fields_edit').html(_html);
                    $('#EditdocInformation').modal('show');


                    loader(false);
                },
                error: function(response) {
                    loader(false);
                   if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        function _doc_information_update()
        {
              loader(true);

              var _FormData = new FormData($('.edit_doc_form')[0]);

              $.ajax({
                          type: "POST",
                          headers: {
                              'X-CSRF-TOKEN': '{{ csrf_token() }}'
                          },
                          url : `/required-document/update`,
                          data : _FormData,
                          processData: false,
                          contentType: false, 
                          success: function(response) {
                             toastr.success(response.message);
                             _required_documents(response.data.required_documents);
                              $('#EditdocInformation').modal('hide');

                             loader(false);
                          },
                          error: function(response) {
                            loader(false);
                      if (response.status == 500) {
                        toastr.error("Something went wrong")
                      }
                      else
                      {
                        toastr.error(response.responseJSON.message)
                      }
                        }
              });

        }

        function _doc_info_delete_modal(_this)
        {
            var id = $(_this).attr('data-id');
            $('#delete-doc-info-id').attr('data-id', id);
            $('#delete_doc').modal('show');
        }

        function _delete_doc(_this)
        {
            var id = $(_this).attr('data-id');

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "DELETE",
                url: "{{ url('/required-document') }}/" + id,
                success: function(response) {
                    toastr.success(response.message);
                    _required_documents(response.data.required_documents);
                    $('#delete_doc').modal('hide');

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function add_more_fields(id)
        {
            append_html(id);
        }

        function add_more_fields_edit(id)
        {
            append_html_edit(id);
        }

        function remove_a_field(_this)
        {
            
            if($('.fields_row').length == 1)
            {
                toastr.error("Last field can't be removed");              
            }
            else
            {
                $(_this).parent().parent().parent().remove();
            }
        }


        function remove_a_field_edit(_this)
        {

        if($(_this).attr('data-hasdata') == 0)
        {
            console.log('has data 0')
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "POST",
                url: "{{ url('/required-document-field-delete') }}",
                data: {'id': $(_this).attr('data-id')},
                success: function(response) {

                    if($('.fields_row').length == 1)
                    {
                        toastr.error("Last field can't be removed");              
                    }
                    else
                    {
                        $(_this).parent().parent().parent().remove();
                    }
                   
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }
        else
        {
            console.log('has data 1')
            toastr.error("Can`t remove this field")
        }

        }

        function add_doc_modal()
        {
            $('.title').val('');
            $('.for_who[value="0"]').prop('checked', true);
            $('.append_fields').html('');
            $('.count-field').val(0);
            append_html('AddDocuments');
        }

        function append_html(id)
        {
           var i =  parseInt($('.count-field').val());

            var _html = `
                        <div class="mt-2 row fields_row">
                            <div class="col-1">
                                <input type="text"  onchange="if (!this.value.match(/^[1-9]$/)) { this.value = '1'; }" class="form-control mt-2 priority" value="1"  name="priority[${i}]">
                            </div>
                            <div class="col-4">
                                <input type="text" class="form-control mt-2 field_name" placeholder="Field Name" name="field_name[${i}]">
                            </div>
                            <div class="col-3">
                                <select class="form-select mt-2 field_type" name="field_type[${i}]" >
                                    <option value="text">Text</option>
                                    <option value="number">Number</option>
                                    <option value="date">Date</option>
                                    <option value="file">Image</option>
                                </select>
                            </div>
                            <div class="col-2 text-center">
                                <input type="hidden" value="0" name="field_required[${i}]">
                                <div class="col-12 d-flex justify-content-center align-items-center h-100"><input type="checkbox" class="form-check-input field_required" placeholder="Field Required" value="1"  name="field_required[${i}]"></div>
                            </div>
                            <div class="col-2 text-center">
                                <div class="col-12 d-flex justify-content-center align-items-center h-100"><div role="button" style="color: #1A2D4D;" class="mdi mdi-close-circle mdi-24px" onclick="remove_a_field(this);" ></div></div>
                            </div>
                        </div>`;

                   $(`#${id} .append_fields`).append(_html);
                    
                   i = i + 1;
                  $('.count-field').val(i);
                  
        }


        function append_html_edit(id)
        {
           var i =  parseInt($('.count-field').val());

            var _html = `
                        <div class="mt-2 row fields_row">
                            <div class="col-1">
                                <input type="text"  onchange="if (!this.value.match(/^[1-9]$/)) { this.value = '1'; }" class="form-control mt-2 priority" value="1"  name="priority[${i}]">
                            </div>
                            <div class="col-3">
                                <input type="text" class="form-control mt-2 field_name" placeholder="Field Name" name="field_name[${i}]">
                                <input type="hidden" value="0" name="id_list[${i}]">
                                <input type="hidden" value="0" name="has_data[${i}]">
                            </div>
                            <div class="col-2">
                                <select class="form-select mt-2 field_type" name="field_type[${i}]" >
                                    <option value="text">Text</option>
                                    <option value="number">Number</option>
                                    <option value="date">Date</option>
                                    <option value="file">Image</option>
                                </select>
                            </div>
                            <div class="col-2 text-center">
                                <input type="hidden" value="0" name="field_required[${i}]">
                                <div class="col-12 d-flex justify-content-center align-items-center h-100"><input type="checkbox" class="form-check-input field_required" placeholder="Field Required" value="1"  name="field_required[${i}]"></div>
                            </div>
                            <div class="col-2">
                                <select class="form-select mt-2 status"  name="status[${i}]" >
                                    <option value="1">Active</option>
                                    <option value="0">InActive</option>
                                </select>
                            </div>
                            <div class="col-2 text-center">
                                <div class="col-12 d-flex justify-content-center align-items-center h-100"><div role="button" style="color: #1A2D4D;" class="mdi mdi-close-circle mdi-24px" onclick="remove_a_field(this);" ></div></div>
                            </div>
                        </div>`;

                   $(`#${id} .append_fields_edit`).append(_html);
                    
                   i = i + 1;
                  $('.count-field').val(i);
                  
        }

    </script>
