<div class="tab-pane fade" id="navs-top-roster" role="tabpanel">
    <div class="card mb-4 ">
        <div class="border-bottom p-3">
            <div class="h4 pb-0 mb-0 ">Create Link</div>
            <small>Link Management - Create Link</small>
        </div>
        <div class="px-2 px-md-4 g-0 ">
            <div class="px-2 py-3 px-md-4 pb-3">
                <form method="post" id="internal-employee-roster-setting-form" class="row gy-3">
                    <div class="col-md-6">
                        <label for="title" class="form-label">Title</label>
                        <input type="text" name="title" class="form-control" required id="roster_setting_title">
                    </div>

                    <div class="col-md-5">
                        <label for="paid_break" class="form-label">Paid Break (minutes)</label>
                        <input type="number" name="paid_break" min="0" value="0" class="form-control" id="roster_setting_paid_break">
                    </div>

                    <div class="col-md-1">
                        <label for="color_code" class="form-label">Color Code </label>
                        <input type="color" name="color_code" style="width: 70px; height:36px" value="#FF0000" id="roster_setting_color_code"
                            class="form-control">
                    </div>

                    <div class="col-md-4">
                        <label for="start_time" class="form-label">Start Time</label>
                        <input type="time" name="start_time" class="form-control" id="roster_setting_start_time">
                    </div>

                    <div class="col-md-4">
                        <label for="end_time" class="form-label">End Time</label>
                        <input type="time" name="end_time" class="form-control" id="roster_setting_end_time">
                    </div>

                    <div class="col-md-4">
                            <div class="mb-3">
                                <label for="" class="form-label">Total Required Hours</label>
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" aria-label="Sizing example input"
                                        id="roster_setting_working_hours" value="0" aria-describedby="roster_setting_working_hours">
                                    <span class="input-group-text" id="roster_setting_working_hours         ">hours</span>
                                </div>
                            </div>
                        </div>

                    <div class="col-md-12">
                        <label for="description" class="form-label">Description</label>
                        <textarea name="description" class="form-control" id="roster_setting_description"></textarea>
                    </div>

                    <div class="col-12">
                        <label class="form-label">Working Days</label>
                        <fieldset class="pt-2">
                            <div class="btn-group d-flex flex-wrap" role="group" aria-label="Working Days">
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="monday" value="Monday" checked
                                        autocomplete="off">
                                    <label class="btn btn-outline-primary" for="monday">Monday</label>
                                </div>
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="tuesday" value="Tuesday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="tuesday">Tuesday</label>
                                </div>
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="wednesday" value="Wednesday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="wednesday">Wednesday</label>
                                </div> 
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="thursday" value="Thursday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="thursday">Thursday</label>
                                </div>
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="friday" value="Friday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="friday">Friday</label>
                                </div>
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="saturday" value="Saturday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="saturday">Saturday</label>
                                </div>
                                <div class="form-check form-check-inline Workin_Day_Width">
                                    <input type="checkbox" class="btn-check" name="working_days[]"
                                        onclick="append_text()" id="sunday" value="Sunday" autocomplete="off">
                                    <label class="btn btn-outline-primary" for="sunday">Sunday</label>
                                </div>
                            </div>
                        </fieldset>
                    </div>

                    <div class="col-12">
                        <label class="form-label">How many days of roster will generate by default</label>
                        <div class="d-md-flex flex-wrap gap-2 HMDORWGBY mt-2">
                            <label class="btn btn-outline-primary" for="custom_number_of_days">Custom</label>
                            <input type="number" class="form-control width_class Workin_Day_Width"
                                name="input_number_of_days" id="roster_setting_number_of_days" min=1 value="1" onchange="append_text_value($(this).val())">
                        </div>
                    </div>

                    <div class="col-12 mt-5 append_text"></div>
                    <div class="col-12 text-center">
                        <button type="button" class="btn btn-primary mt-5" onclick="_submit()">Save</button>
                    </div>
                </form>

            </div>

        </div>

    </div>
</div>

@section('css-js')
<script>

    $(document).ready(function () {
        loader(false);
        get_internal_employee_roster_setting();
    });

    function get_internal_employee_roster_setting()
    {
        loader(true);

        $.ajax({
            type: "GET",
            url: "{{url('/internal-employee-roster-setting')}}",
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function(response) {
                internal_employee_roster_setting_append(response.data);

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else  if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }
    
    function append_text_value(number_of_days) {
        var selectedValues = [];
        var checkboxes = $('input[name="working_days[]"]');
        for (var i = 0; i < checkboxes.length; i++) {
            if (checkboxes[i].checked) {
                selectedValues.push(checkboxes[i].value);
            }
        }


        if (number_of_days <= 0) {
            var html = ``;
        } else if (number_of_days == 1) {
            var html =
                `<b class="text-danger">Note:</b> You are assigning the roster from the <b>current(the day when user register)</b> day .`;
        } else {
            var html =
                `<b class="text-danger">Note:</b> You are assigning the roster from the current(the day when user register)</b> day to the next <b>${number_of_days}</b> days for all the <b>${selectedValues.toString()}</b> in between.`;
        }

        $('.append_text').html(html);
    }

    function append_text() {
        var selectedValues = [];
        var checkboxes = $('input[name="working_days[]"]');
        for (var i = 0; i < checkboxes.length; i++) {
            if (checkboxes[i].checked) {
                selectedValues.push(checkboxes[i].value);
            }
        }

        var number_of_days = $("input[name='input_number_of_days']").val();

        if (number_of_days <= 0) {
            var html = ``;
        } else if (number_of_days == 1) {
            var html =
                `<b class="text-danger">Note:</b> You are assigning the roster from the <b>current(the day when user register)</b> day .`;
        } else {
            var html =
                `<b class="text-danger">Note:</b> You are assigning the roster from the <b>current(the day when user register)</b> day to the next <b>${number_of_days}</b> days for all the <b>${selectedValues.toString()}</b> in between.`;
        }

        $('.append_text').html(html);
    }

    function _submit() {
        var _FormData = new FormData($('#internal-employee-roster-setting-form')[0]);
        var num_days = $("#roster_setting_number_of_days").val();

        if (num_days < $('input[name="working_days[]"]:checked').length) {
            toastr.error("Custom roster day must be more or equal to selected Working Days")
            return 0;
        }

        _FormData.append('number_of_days', $("#roster_setting_number_of_days").val());
        _FormData.append('working_hours', $("#roster_setting_working_hours").val());

        loader(true);

        $.ajax({
            type: "POST",
            url: "{{ url('/internal-employee-roster-setting') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: _FormData,
            processData: false,
            contentType: false,
            success: function(response) {
                loader(false);
                toastr.success(response.message);
                internal_employee_roster_setting_append(response.data);
            },
            error: function(response) {
                loader(false);
                if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    function internal_employee_roster_setting_append(data){
        data.forEach(item => {
            const element = document.getElementById(item.option);
            if (element) {
                element.value = item.value;
            }
        });

        // Handle working days separately as checkboxes
        const workingDays = data.find(item => item.option === 'roster_setting_working_days').value.split(',');
        workingDays.forEach(day => {
            const checkbox = document.getElementById(day.toLowerCase());
            if (checkbox) {
                checkbox.checked = true;
            }
        });
    }

</script>
@endsection
