@extends('includes/layout')

@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Salary Management</div>
                        <small>Dashboard - Salary Management</small>
                    </div>
                    <div>
                        @if (in_array('Sites Maintain', Session::get('permissions')))
                            <button class="btn btn-primary" onclick="window.location='{{ route('salary.create') }}'"><span
                                    class="mdi mdi-plus"></span>Add Salary</button>
                        @endif
                    </div>
                </div>
                <form method="GET" action="{{ route('salary.index') }}" class="mt-3">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="employe">Employee</label>
                            <select class="form-control" name="employee">
                                <option value="">Select Employee</option>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ ($filters['employee'] ?? '') == $employee->id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="col-md-2 mb-3">
                            <label for="from">From</label>
                            <input type="month" name="from" id="from"
                                value="{{ isset($filters['from']) ? $filters['from'] : '' }}" class="form-control mt-1">
                        </div>

                        <div class="col-md-2 mb-3">
                            <label for="to">To</label>
                            <input type="month" name="to" id="to"
                                value="{{ isset($filters['to']) ? $filters['to'] : '' }}" class="form-control mt-1">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="salary">Salary</label>
                            <input class="form-control" placeholder="Amount" type="number" name="basic_salary"
                                value="{{ isset($filters['basic_salary']) ? $filters['basic_salary'] : '' }}">
                        </div>
                        {{-- <div class="col-md-2 mb-3">
                            <label for="working_hours">Working Hours</label>
                            <input class="form-control" placeholder="Hours" type="number" name="working_hours"
                                value="{{ isset($filters['working_hours']) ? $filters['working_hours'] : '' }}">
                        </div> --}}
                        <div class="col-md-12 text-end">
                            <button type="submit" class="btn btn-secondary">Filter</button>
                            <a href="{{ route('salary.index') }}" class="btn btn-danger">Reset</a>
                        </div>
                    </div>
                </form>
                <div class="table-responsive text-nowrap mt-3">
                    <table class="table">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th>Employee</th>
                                <th>From</th>
                                <th>To</th>
                                <th>Salary</th>
                                {{-- <th>Working Hours</th> --}}
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($fines as $fine)
                                <tr>
                                    <td>{{ $fine->employee ? trim($fine->employee->first_name . ' ' . ($fine->employee->middle_name ?? '') . ' ' . $fine->employee->last_name) : 'N/A' }}
                                    </td>
                                    <td>{{ $fine->from }}</td>
                                    <td>{{ $fine->to }}</td>
                                    <td>{{ $fine->basic_salary }}</td>
                                    {{-- <td>{{ $fine->working_hours }}</td> --}}
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle" type="button"
                                                id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="mdi mdi-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <li><a class="dropdown-item"
                                                        href="{{ route('salary.edit', $fine->id) }}">Edit</a></li>
                                                <li>
                                                    <form method="POST" action="{{ route('salary.destroy', $fine->id) }}"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" class="dropdown-item"
                                                            onclick="confirmDeletion(event, this)">Delete</button>
                                                    </form>

                                                </li>
                                            </ul>
                                        </div>
                                    </td>

                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center">No fines found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $fines->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        function confirmDeletion(event, element) {
            event.preventDefault(); // Prevent the default form submission on button click

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // If the user confirms, submit the form programmatically
                    element.closest('form').submit(); // Corrected this line
                }
            });
        }
    </script>
@endsection
