@extends('includes/layout')
@section('main-page-content')
    <style>
        .suggestions {
            margin-top: 10px;
            max-height: 200px;
            overflow-y: auto;
            max-width: 350px;
            border: none;
            z-index: 100;
        }

        .suggestion {
            padding: 10px;
            cursor: pointer;
        }

        .suggestion:hover {
            background-color: #f5f5f5;
        }

        .suggestions.has-suggestions {
            border: 1px solid #ccc;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Edit Site</div>
                    <small>Dashboard-Site Manager-Edit</small>
                </div>
                <form id="siteForm">
                    <input type="hidden" value="{{ $site->id }}" id="site_id">
                    @csrf
                    <div class="row mt-3">
                        <div class="col-md-4 form-group mb-3">
                            <label for="site_title" class="text-dark">Title<span class="text-danger">*</span></label>
                            <input type="text" name="title" class="title form-control mt-1"
                                value="{{ $site->title }}" placeholder="Enter Site Title">
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="site_address" class="text-dark">State<span class="text-danger">*</span></label>
                            <input type="text" name="state" class="site_state form-control mt-1"
                                value="{{ $site->site_state }}" placeholder="State">

                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="site_state" class="text-dark">External Id</label>
                            <input type="text" name="external_id" class="external_id form-control mt-1"
                                value="{{ $site->external_id }}" placeholder="External Id">
                        </div>


                       
                        <div class="col-md-6 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Supervisor<span class="text-danger">*</span></label>
                            <select class="supervisor_id form-select mt-1" name="supervisor">
                                <option value="">--Select--</option>
                                @foreach ($get_employes as $get_employe)
                                    @if ($get_employe->EmpPersonalDetails)
                                        <option value="{{ $get_employe->id }}" {{$site->supervisor_id ==  $get_employe->id ? 'selected' : ''}}>
                                            {{ $get_employe->EmpPersonalDetails->first_name }}
                                            {{ $get_employe->EmpPersonalDetails->middle_name }}
                                            {{ $get_employe->EmpPersonalDetails->last_name }}
                                        </option>
                                    @endif
                                @endforeach
                            </select>
                        </div>
                       



                        <div class="col-md-6 form-group mb-3">
                            <label for="site_description" class="text-dark">Description</label>
                            <textarea name="description" class="description form-control mt-1" placeholder="Description">{{ $site->description }}</textarea>
                        </div>

                        <div class="col-md-6 form-group mb-3">
                            <label for="site_address" class="text-dark">Address<span class="text-danger">*</span></label>
                            <textarea name="address" class="street_address form-control mt-1" placeholder="Address">{{ $site->street_address }}</textarea>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="site_title_latit" class="text-dark">Latitude<span class="text-danger">*</span></label>
                            <input type="text" id="site_title_latit" name="latitude"class="latitude form-control mt-1"
                                value="{{ $site->latitude }}" placeholder="Latitude">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="site_title_logni" class="text-dark">Longitude<span class="text-danger">*</span></label>
                            <input id="site_title_logni" type="text" name="longitude" class="longitude form-control mt-1"
                                value="{{ $site->longitude }}" placeholder="Longitude">
                        </div>


                        <div class="col-md-4 form-group mb-3">
                            <label for="site_title_radius" class="text-dark">Area Radius<span class="text-danger">(KM)*</span></label>
                            <input id="site_title_radius" type="text" name="area_radius"
                                class="area_radius form-control mt-1" value="{{ $site->area_radius }}" placeholder="Area Radius">
                        </div>


                        <div class="col-md-12 form-group mb-3">
                            <div class="input-group mb-3" style="position: relative;">
                                <input type="text" class="form-control address-input" id="search_input"
                                    placeholder="Search for..." aria-label="Search for..." aria-describedby="button-addon2">
                                <button class="btn btn-primary" type="button" id="search_button"><i
                                        class="mdi mdi-magnify"></i></button>
                            </div>
                            <div class="suggestions m-0"
                                style="background:white; z-index: 100; z-index: 100; position: absolute; ">
                            </div>
                            <div class="details"></div>
                        </div>
                        <div class="col-md-12 p-3 py-2">
                            <div id="map" class="shadow rounded" style="height: 450px;"></div>
                        </div>

                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <button type="button" class="btn btn-secondary me-2" onclick="window.location='{{ url('/') }}/sites'">CANCEL</button>
                        <button type="button" onclick="_update()" class="btn btn-primary">Save And Submit</button>
                    </div>
            </div>
        </div>
        </form>
    </div>
@endsection
@section('css-js')
    <script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB7aLtWqhztn7r4Fcce7WqQT-Qdlpl7MnQ&callback=initMap&v=weekly"
        async defer></script>


    <script>
        function _update() {
            var formData = $('#siteForm').serialize();
            var lrequestId = $('#site_id').val();
            $.ajax({
                url: "{{ url('api/site-update') }}/" + lrequestId,
                type: 'POST',
                data: formData,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    window.location.href = "{{ url('/') }}/sites";
                },
                error: function(response) {
                if (response.status == 500) {
                        toastr.error("Something went wrong")
                    }
                    else
                    {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        const citymap = {
            vancouver: {
                center: {
                    lat: {{$site->latitude}},
                    lng: {{ $site->longitude }}
                },
                population: {{$site->area_radius}},
                borderColor: 'blue',
                fillColor: 'green',
                circle: null,
            },
        };

        let marker;

        function initMap() {
  const map = new google.maps.Map(document.getElementById('map'), {
    zoom: 17,
    center: { lat: {{$site->latitude}}, lng: {{ $site->longitude }} },
    mapTypeId: 'terrain',
  });
  let marker;

  map.addListener('click', (event) => {
    const latitude = parseFloat(event.latLng.lat().toFixed(6));
    const longitude = parseFloat(event.latLng.lng().toFixed(6));

    console.log('Latitude:', latitude);
    console.log('Longitude:', longitude);
    citymap.vancouver.circle.setCenter({ lat: parseFloat(latitude), lng: parseFloat(longitude) });

    document.getElementById('site_title_logni').value = longitude;
    document.getElementById('site_title_latit').value = latitude;
    if (marker) {
      marker.setMap(null);
    }
    marker = new google.maps.Marker({
      position: event.latLng,
      map: map,
      draggable: true,
    });

    google.maps.event.addListener(marker, 'dragend', function () {
      document.getElementById('site_title_logni').value = marker.getPosition().lng().toFixed(6);
      document.getElementById('site_title_latit').value = marker.getPosition().lat().toFixed(6);
    });
  });
  for (const city in citymap) {
    const cityCircle = new google.maps.Circle({
      strokeColor: citymap[city].borderColor,
      strokeOpacity: 0.8,
      strokeWeight: 2,
      fillColor: citymap[city].fillColor,
      fillOpacity: 0.35,
      map,
      center: citymap[city].center,
      radius:citymap[city].population * 1000,
    });
    citymap[city].circle = cityCircle;
  }

  const searchButton = document.getElementById('search_button');
  searchButton.addEventListener('click', function () {
  const searchInput = document.getElementById('search_input').value;
    const geocoder = new google.maps.Geocoder();
    geocoder.geocode({ address: searchInput }, function (results, status) {
      if (status === 'OK' && results.length > 0) {
        const location = results[0].geometry.location;
        const latitude = location.lat().toFixed(6);
        const longitude = location.lng().toFixed(6);

        document.getElementById('site_title_logni').value = longitude;
        document.getElementById('site_title_latit').value = latitude;
        map.setCenter(location);
        if (marker) {
          marker.setMap(null);
        }
        marker = new google.maps.Marker({
          position: location,
          map: map,
          draggable: true,
        });

        google.maps.event.addListener(marker, 'dragend', function () {
          document.getElementById('site_title_logni').value = marker.getPosition().lng().toFixed(6);
          document.getElementById('site_title_latit').value = marker.getPosition().lat().toFixed(6);
         
        });
      } else {
        console.error('Geocode was not successful for the following reason:', status);
      }
    });
  });

  const areaRadiusInput = document.getElementById('site_title_radius');
  areaRadiusInput.addEventListener('input', function () {
    const newPopulation = parseFloat(areaRadiusInput.value) || 0.8; 

    citymap.vancouver.population = newPopulation;
    citymap.vancouver.circle.setRadius(newPopulation * 1000);
  });
}


        window.initMap = initMap;


        var apiKey = 'AgZX0rYQbjfv4k7X9FgD7qZOFbk-cdyVG8PQH582yHiIubT07RL65I2URD9GTWnB';

        var addressInputs = document.querySelectorAll('.address-input');
        var suggestionsContainers = document.querySelectorAll('.suggestions');
        var detailsContainers = document.querySelectorAll('.details');

        addressInputs.forEach((addressInput, index) => {
            const suggestionsContainer = suggestionsContainers[index];
            const detailsContainer = detailsContainers[index];

            addressInput.addEventListener('input', async () => {
                const query = addressInput.value;
                suggestionsContainer.innerHTML = '';

                if (query.length >= 3) {
                    const suggestionEndpoint =
                        `https://dev.virtualearth.net/REST/v1/Autosuggest?query=${query}&key=${apiKey}`;
                    const response = await fetch(suggestionEndpoint);
                    const data = await response.json();

                    const suggestions = data.resourceSets[0].resources[0].value;

                    suggestions.forEach(suggestion => {
                        if (suggestion.__type === "Address") {
                            const formattedAddress = suggestion.address.formattedAddress;
                            const suggestionItem = document.createElement('div');
                            suggestionItem.classList.add('suggestion');
                            suggestionItem.textContent = formattedAddress;
                            suggestionItem.addEventListener('click', () => {
                                displayDetails(suggestion, detailsContainer);
                                addressInput.value = formattedAddress;
                                suggestionsContainer.innerHTML = '';
                            });
                            suggestionsContainer.appendChild(suggestionItem);
                        }
                    });
                    suggestionsContainer.classList.add('has-suggestions');
                } else {
                    suggestionsContainer.classList.remove('has-suggestions');
                }
            });

            document.addEventListener('click', (event) => {
                if (event.target !== addressInput && event.target !== suggestionsContainer) {
                    suggestionsContainer.innerHTML = '';
                    detailsContainer.innerHTML = '';
                    suggestionsContainer.classList.remove('has-suggestions');
                }
            });
        });

        function displayDetails(suggestion, detailsContainer) {
            if (suggestion.__type === "Address") {
                const address = suggestion.address;
                const details = `
              <h2>Details</h2>
              <p>Country/Region: ${address.countryRegion}</p>
              <p>Locality: ${address.locality}</p>
              <p>Admin District: ${address.adminDistrict}</p>
              <p>Postal Code: ${address.postalCode}</p>
              <p>Street Address: ${address.addressLine}</p>
              <p>Street Name: ${address.streetName}</p>
              <p>Formatted Address: ${address.formattedAddress}</p>
          `;
                detailsContainer.innerHTML = details;
            }
        }
    </script>


    <style>

    </style>
@endsection
