@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div
                    class="border-bottom py-2 d-md-flex justify-content-md-between
                    justify-content-start align-items-md-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Site List</div>
                        <small>Dashboard-Site List</small>
                    </div>
                    <div class="d-md-flex justify-content-md-end align-items-md-center mt-3 mt-md-0">
                        @if (in_array('Sites Maintain', Session::get('permissions')))
                            <button class="btn btn-primary" onclick="window.location='{{ route('sites.create') }}'"><span
                                    class="mdi mdi-plus"></span>Add Site</button>
                        @endif
                    </div>
                </div>
                <div class="mt-3">
                    <div class="table-responsive text-nowrap mt-3 border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="width: 10%;">
                                        <input type="text" class="filter form-control" name="title" id=" "
                                            placeholder="Title" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-title" autocomplete="false">
                                    </th>
                                    <th>
                                        <input type="text" class="filter form-control" name="first_name" id=""
                                            placeholder="Supervisor" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name"
                                            autocomplete="false">
                                    </th>
                                    <!-- <th>
                                        <input type="text" class="filter form-control" name="company" id=""
                                            placeholder="Client/Company" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-company" autocomplete="false">
                                    </th> -->
                                    <th>
                                        <input type="text" class="filter form-control" name="area_radius" id=""
                                            placeholder="Radius" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-area_radius"
                                            autocomplete="false">
                                    </th>

                                    <th>
                                        <select class="filter select-color" name="active" id="">
                                            <option value="">Select</option>
                                            <option value="1">Active</option>
                                            <option value="0">InActive</option>
                                        </select>
                                    </th>


                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3 ">
                        <ul class="pagination justify-content-end pages_btn">
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="site-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection





@section('css-js')
    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);

        });

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {

            $.ajax({
                type: "GET",
                url: `{{ url('api/sites-get') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    var sites = response.data.sites;
                    console.log(sites);
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                </li>
                                      <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                        <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                      </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                  <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>
                                `;
                        }

                    }

                    pages_btn += `

                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                </li>
                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                </li>
                `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < sites.length; i++) {
                        html += `
                    <tr>
                        <td>${sites[i].title}</td>
                        <td>${sites[i].emp_personal_details? (sites[i].emp_personal_details.middle_name? `${sites[i].emp_personal_details.first_name} ${sites[i].emp_personal_details.middle_name} ${sites[i].emp_personal_details.last_name}` : `${sites[i].emp_personal_details.first_name} ${sites[i].emp_personal_details.last_name}`) : ''}</td>
                        <td>${sites[i]?.area_radius ? sites[i]?.area_radius : ''}</td>
                        <td class="status-col${sites[i]?.id}">
                            ${sites[i]?.active == "1" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Active</span>'
                            :
                            '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>'
                             }
                            </td>


                              <td>
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              @if (in_array('Sites Maintain', Session::get('permissions')))
                              <li><a class="dropdown-item py-1 ps-2"  onclick="window.location='/sites/${sites[i]?.id}/edit'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li class="d-none"><a class="dropdown-item py-1 ps-2" data-id="${sites[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              <li><a class="dropdown-item py-1 ps-2"   onclick="_change_status(${sites[i]?.id});"><span  class="mdi status${sites[i]?.id}   ${sites[i]?.active == 1? 'mdi-pan-down text-secondary' : 'mdi-pan-up text-info' }  mdi-20px"></span>${sites[i]?.active == 1 ? 'Inactive' : 'Active' }</a></li>
                              @endif
                              <li><a class="dropdown-item py-1 ps-2" onclick="window.location='/site-view/${sites[i]?.id}'"><span class="mdi mdi-eye text-primary"></span> View Detail</a></li>
                              </ul>
                              </div>
                            </td>
                    </tr>`;
                    }

                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#site-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "POST",
                url: "api/site-delete/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    location.reload();
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Failed to delete Site");
                }
            });
        }



        function _change_status(id) {

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "PUT",
                url: "api/site/" + id + "/update-status",
                success: function(response) {

                    var tooltip = response.data.status == 0 ? 'Click to Active Site' : 'Click to InActive Site';
                    var icon_add = response.data.status == 1 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var icon_remove = response.data.status == 0 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var color_add = response.data.status == 1 ? 'text-info' : 'text-secondary';
                    var color_remove = response.data.status == 0 ? 'text-info' : 'text-secondary';

                    var html = response.data.status == 1 ?
                        '<span class="badge rounded-pill bg-label-success me-1">Active</span>' :
                        '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>';

                    $('.status-btn' + id).attr('data-bs-original-title', tooltip);
                    $('.status' + id).removeClass(icon_remove);
                    $('.status' + id).addClass(icon_add);
                    $('.status' + id).removeClass(color_remove);
                    $('.status' + id).addClass(color_add);
                    $('.status-col' + id).html(html);

                    // toastr.success(response.message);
                    location.reload();

                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }
    </script>


    <style>
        .filter {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;

        }


        .select-color {
            color: #787878;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 2px;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }
    </style>
@endsection
