<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="assets/" data-template="vertical-menu-template-free">

<head>
    <title>{{ env('APP_NAME') }}</title>
    <meta charset="utf-8" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    @include('includes/CSSLinks')
    <style>


      .notification_bg_color
      {
        background: #f9f9e7;
      }

      .table_loader
      {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-position: center;
        background-size: 50px;
        background-color: white;
        color:black;
        height: 100px;
        width: 100%
      }

      .full_loader
      {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-position: center;
        background-size: 50px;
        z-index: 5000;
        position: absolute;
        min-width: 200vw;
        min-height: 200vh;
        overflow: hidden;
        max-width: 200vw;
        max-height: 200vh;
        background-color: white;
        color:black;
      }


      .mini_loader
      {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-position: center;
        background-size: 50px;
        z-index: 5000;
        position: absolute;
        width: 98%;
        min-height: 150px;
        overflow: hidden;
        max-height: 100%;
        background-color: white;
        color:black;
      }


    @media (max-width: 768px) {
      .mini_loader {
        width: 97%;
      }
    }

    @media (max-width: 425px) {
      .mini_loader {
        width: 95%;
      }
    }


        input[type="date"]::-webkit-datetime-edit, input[type="date"]::-webkit-inner-spin-button, input[type="date"]::-webkit-clear-button {
        position: relative;
        color:white;
        }

        .full_loader {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 5000;
            position: absolute;
            min-width: 200vw;
            min-height: 200vh;
            overflow: hidden;
            max-width: 200vw;
            max-height: 200vh;
            background-color: white;
            color: black;
        }


        .mini_loader {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-position: center;
            background-size: 50px;
            z-index: 5000;
            position: absolute;
            width: 98%;
            min-height: 150px;
            overflow: hidden;
            max-height: 100%;
            background-color: white;
            color: black;
        }


        @media (max-width: 768px) {
            .mini_loader {
                width: 97%;
            }
        }

        @media (max-width: 425px) {
            .mini_loader {
                width: 95%;
            }
        }


        input[type="date"]::-webkit-datetime-edit,
        input[type="date"]::-webkit-inner-spin-button,
        input[type="date"]::-webkit-clear-button {
            position: relative;
            color: white;
        }

        input[type="date"]::-webkit-datetime-edit-year-field {
            position: absolute !important;
            border-left: 1px solid #8c8c8c;
            padding-left: 6px;
            left: 74px;
            color: black;
        }

        input[type="date"]::-webkit-datetime-edit-month-field {
            position: absolute !important;
            border-left: 1px solid #8c8c8c;
            padding-left: 7px;
            left: 35px;
            color: black;
        }

        input[type="date"]::-webkit-datetime-edit-day-field {
            position: absolute !important;
            left: 4px;
            color: black;
        }



        .history-box {
            border-left: 2px solid lightgray;
            padding-bottom: 18px;
            padding-left: 10px;
            line-height: 100% !important;
            position: relative;
        }

        .history-circle {
            width: 10px;
            height: 10px;
            background-color: lightgray;
            border-radius: 5px;
            position: absolute;
            top: 0;
            left: -6px;
        }

        .history-circle-active {
            background-color: #15A7F5;
        }

        .history-box-last {
            border-color: transparent;
        }


        .btn-text-white {
            color: white !important;
            padding: 2px;
        }

        .history-box {
            border-left: 2px solid lightgray;
            padding-bottom: 18px;
            padding-left: 10px;
            line-height: 100% !important;
            position: relative;
        }

        .history-circle {
            width: 10px;
            height: 10px;
            background-color: lightgray;
            border-radius: 5px;
            position: absolute;
            top: 0;
            left: -6px;
        }

        .history-circle-active {
            background-color: #15A7F5;
        }

        .history-box-last {
            border-color: transparent;
        }

        .borderd_div {
            border-radius: 10px;
            background-color: #FBFBFB;
        }

        @media screen and (max-width:768px) {
            .project-detail {
                border-bottom: 1px solid gainsboro !important;
                border-right: transparent !important;
            }
        }

        @media screen and (max-width:768px) {
            .site-detail {
                border-bottom: 1px solid gainsboro !important;
                border-right: transparent !important;
            }

            .create_by_site {
                margin-top: 5px !important;
            }

            .site_title {
                margin-top: 5px !important;
            }
        }

        .text_color {
            color: #000000;
        }

        .suggestions {
            margin-top: 10px;
            max-height: 200px;
            overflow-y: auto;
            max-width: 350px;
            border: none;
            z-index: 100;
        }

        .suggestion {
            padding: 10px;
            cursor: pointer;
        }

        .suggestion:hover {
            background-color: #f5f5f5;
        }

        .suggestions.has-suggestions {
            border: 1px solid #ccc;
        }

        .upload-log-file {
            font-size: 9px;
            margin: 6px;
        }

        .image-text {
            font-size: 12px;
            text-align: center;
            margin-top: 5px;
        }

        .upload-log-file::-webkit-file-upload-button {
            background-color: #56CA00;
            color: #FFFFFF;
            border-radius: 5px;
            padding: 3px 5px;
            border: none;
        }

        .img-box {
            border: 1px solid lightgray;
            width: 138px;
            height: 105px;
            overflow: hidden;
        }

        .bg-image {
            background-repeat: repeat-y;
            background-size: cover;
            width: 65px;
            height: 65px;
            margin: auto;
            margin-top: 1px;


        }

        ::-webkit-input-placeholder {
            font-size: 12px !important;
        }

        .text_color {
            color: #484848;
            font-weight: 400;
        }

        .border_round {
            border-radius: 6px;
            width: 48px;
            color: #019FF3;
            line-height: 12px;
            font-weight: 400;
            height: 35px;
        }

        .text_size {
            font-size: 16px;
            font-weight: 400;
        }

        .set_bg_colot:hover {
            background-color: #9ed3ef33;
        }

        .search_div.selected {
            background-color: #019FF333;
        }

        .set_bg_colot {
            transition: background-color 0.4s;
        }

        .bg-primary th {
            color: white !important;
        }

        .break_width {
            width: 48%;
        }

        .btn_width {
            width: 2%;
            margin-top: 20px;
        }

        .input_search {
            outline: none;
            border: none;
            background-color: #F4F5FA;
            border-radius: 4px;
            width: 189px;
            height: 30px;
            flex-shrink: 0;
        }
        .dropdown:after {
            content: none !important;
            border: none !important;
        }
        .dropdown:before {
            content: none !important;
            border: none !important;
        }
    </style>
    <link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'>
</head>

<body>
    <div class="full_loader d-none"></div>
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">

            @include('includes/sidebar')

            <div class="layout-page">
                @include('includes/navbar')

                <div class="content-wrapper">
                    @yield('main-page-content')
                </div>
            </div>

        </div>
    </div>

    @include('includes/scriptLinks')
    <script>
        @if (Session::has('success'))
            toastr.success("{{ Session::get('success') }}");
        @endif
        @if (Session::has('error'))
            toastr.error("{{ Session::get('error') }}");
        @endif
        @if (Session::has('info'))
            toastr.info("{{ Session::get('info') }}");
        @endif

        function loader(show) {
            if (show == true) {
                $('.full_loader').removeClass('d-none');
            } else {
                $('.full_loader').addClass('d-none');
            }
        }

        function formate_date(date) {
            var date = date.split('-');
            return `${date[2]}-${date[1]}-${date[0]}`;
        }


        $(document).ready(function() {
            $('.logoutBtn').click(function() {
                // Send an Ajax request to log out the user
                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/logout') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    success: function(response) {

                        toastr.success(response.message);
                        // Redirect to the main URL after logging out
                        window.location.href = '{{ url('/') }}';
                    },
                    error: function(response) {
                        toastr.error("Failed to log out");
                    }
                });
            });
        });


        function _sendCredentials(id) {
            loader(true);

            var _FormData = new FormData();
            _FormData.append("id", id);

            $.ajax({
                type: "POST",
                url: "{{ url('/api/send-credentials') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: _FormData,
                processData: false,
                contentType: false,
                success: function(response) {

                    toastr.success(response.message);
                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function date_formate_style(date) {
            const originalDate = new Date(date);
            const formattedDate = originalDate.toLocaleString('en-AU', {
                month: 'short',
                day: 'numeric',
                year: 'numeric',
                hour: 'numeric',
                minute: 'numeric',
                hour12: true,
                hourCycle: 'h12',
            }).replace(/pm/, 'PM').replace(/am/, 'AM');

            return formattedDate;
        }


        function yyyy_mm_dd(date) {
            var dateObject = new Date(date);
            var year = dateObject.getFullYear();
            var month = ('0' + (dateObject.getMonth() + 1)).slice(-2);
            var day = ('0' + dateObject.getDate()).slice(-2);
            return year + '-' + month + '-' + day;
        }

        function clear_all_notifications() {
            $.ajax({
                type: "POST",
                url: "{{ url('/api/clear-all-notifications') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {

                    $('.dropdown-notifications-item').removeClass('notification_bg_color');

                },
                error: function(response) {
                    toastr.error("Some thing went wrong");
                }
            });


        }


        function _24_to_12_time(time24) {
            // Split the time into hours and minutes
            var timeSplit = time24.split(':');

            // Parse hours and minutes
            var hours = parseInt(timeSplit[0]);
            var minutes = parseInt(timeSplit[1]);

            // Determine AM or PM
            var period = (hours >= 12) ? 'PM' : 'AM';

            // Adjust hours to 12-hour format
            hours = (hours > 12) ? hours - 12 : hours;

            // Handle midnight and noon
            hours = (hours === 0) ? 12 : hours;

            // Pad single digit hours and minutes with leading zero
            hours = (hours < 10) ? '0' + hours : hours;
            minutes = (minutes < 10) ? '0' + minutes : minutes;

            // Construct the 12-hour time format string
            var time12 = hours + ':' + minutes + ' ' + period;

            return time12;
        }

        function convertMinutesToHours(minutes) {
            var isNegative = minutes < 0;
            minutes = Math.abs(minutes);

            var hours = Math.floor(minutes / 60);
            var remainingMinutes = minutes % 60;

            var result = (isNegative ? '-' : '') + hours + 'h:' + (remainingMinutes < 10 ? '0' : '') + remainingMinutes +
                'm';

            return result;
        }
    </script>
    @php
        Session::forget('success');
        Session::forget('error');
        Session::forget('info');
    @endphp


    @yield('css-js')
</body>

</html>
