@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <!-- Overtime Entry Card -->
        <div class="card mb-4">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0">Edit Overtime Entry</div>
            </div>
            <form id="overtime-form">
                {{-- Include method override for PUT --}}
                @method('PUT')
                <div class="row p-3">
                    <div class="col-6 mb-3">
                        <label>Employee</label>
                        <select class="form-select" name="employee_id" aria-label="Default select example">
                            <option value="" disabled>Select Employee</option>
                            @foreach ($get_employes as $get_employe)
                                @if ($get_employe->EmpPersonalDetails)
                                    <option value="{{ $get_employe->id }}"
                                        @if($get_employe->id == $overtime->employee_id) selected @endif>
                                        {{ $get_employe->EmpPersonalDetails->first_name }}
                                        {{ $get_employe->EmpPersonalDetails->middle_name }}
                                        {{ $get_employe->EmpPersonalDetails->last_name }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Site</label>
                        <select class="form-select" name="site_id" aria-label="Default select example">
                            <option value="" disabled>Select Site</option>
                            @foreach ($sites as $site)
                                <option value="{{ $site->id }}"
                                    @if($site->id == $overtime->site_id) selected @endif>
                                    {{ $site->title }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check In</label>
                        <input type="datetime-local" name="check_in" class="form-control"
                               value="{{ date('Y-m-d\TH:i', strtotime($overtime->check_in)) }}">
                    </div>
                    <div class="col-6 mb-3">
                        <label>Check Out</label>
                        <input type="datetime-local" name="check_out" class="form-control"
                               value="{{ date('Y-m-d\TH:i', strtotime($overtime->check_out)) }}">
                    </div>
                    <div class="col-12 col-md-6 mb-3">
                        <label>Date</label>
                        <input type="date" class="form-control" name="date"
                         value="{{ \Carbon\Carbon::parse($overtime->date)->format('Y-m-d') }}">

                    </div>
                    <div class="col-12 col-md-6 mb-3">
                        <label>Status</label>
                        <select class="form-select" name="status">
                            <option value="" disabled>Select Status</option>
                            <option value="1" @if($overtime->status == 1) selected @endif>Pending</option>
                            <option value="2" @if($overtime->status == 2) selected @endif>Approved</option>
                            <option value="3" @if($overtime->status == 3) selected @endif>Reject</option>
                        </select>
                    </div>
                    <div class="col-12 col-md-12 mb-3">
                        <label>Description</label>
                        <textarea class="form-control" name="description"  rows="4">{{$overtime->description ?? ' '}}</textarea>
                    </div>
                </div>
                <div class="border-top p-3 d-flex justify-content-end">
                    <button type="button" class="btn btn-outline-light text-dark me-2"
                        onclick="window.location='{{ url('/') }}/overtimes'">CANCEL</button>
                    <button type="button" class="btn btn-primary waves-effect" onclick="overtime_update();">UPDATE</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('css-js')
    <script>
        function overtime_update() {
            var formData = $('#overtime-form').serialize();

            $.ajax({
                url: "{{ url('/overtimes/' . $overtime->id) }}",
                type: 'POST',
                data: formData,
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    // Use HTTP method override for PUT
                    'X-HTTP-Method-Override': 'PUT'
                },
                success: function(response) {
                    window.location.href = "{{ url('/') }}/overtimes";
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(response.responseJSON.message);
                    }
                }
            });
        }
    </script>
@endsection
